/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Comparator;
import java.util.Iterator;

public class UniqueIterator<E>
implements Iterator<E> {
    private final PeekingIterator<E> iterator;
    private final Comparator<? super E> comparator;

    public UniqueIterator(Iterator<? extends E> iterator) {
        this.iterator = Iterators.peekingIterator(iterator);
        this.comparator = null;
    }

    public UniqueIterator(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        Preconditions.checkArgument((comparator != null ? 1 : 0) != 0, (Object)"null comparator");
        this.iterator = Iterators.peekingIterator(iterator);
        this.comparator = comparator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        Object next = this.iterator.next();
        while (this.iterator.hasNext()) {
            Object peek = this.iterator.peek();
            if (this.comparator != null ? this.comparator.compare(next, peek) != 0 : (next != null ? !next.equals(peek) : peek != null)) break;
            this.iterator.next();
        }
        return (E)next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

