/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;

public final class UnsignedIntEncoder {
    public static final int MAX_ENCODED_LENGTH = 5;
    public static final int MIN_MULTI_BYTE_VALUE = 251;

    private UnsignedIntEncoder() {
    }

    public static byte[] encode(int value) {
        ByteWriter writer = new ByteWriter(UnsignedIntEncoder.encodeLength(value));
        UnsignedIntEncoder.write(writer, value);
        return writer.getBytes();
    }

    public static int decode(byte[] data) {
        ByteReader reader = new ByteReader(data);
        int value = UnsignedIntEncoder.read(reader);
        if (reader.remain() > 0) {
            throw new IllegalArgumentException("encoded value contains extra trailing garbage");
        }
        return value;
    }

    public static void write(ByteWriter writer, int value) {
        writer.makeRoom(5);
        writer.len += UnsignedIntEncoder.encode(value, writer.buf, writer.len);
    }

    public static void write(OutputStream out, int value) throws IOException {
        byte[] array = new byte[5];
        int nbytes = UnsignedIntEncoder.encode(value, array, 0);
        out.write(array, 0, nbytes);
    }

    public static void write(ByteBuffer buf, int value) {
        byte[] array = new byte[5];
        int nbytes = UnsignedIntEncoder.encode(value, array, 0);
        buf.put(array, 0, nbytes);
    }

    public static int read(ByteReader reader) {
        try {
            int value;
            int first = reader.readByte();
            switch (first) {
                case 251: {
                    value = reader.readByte();
                    break;
                }
                case 252: {
                    value = reader.readByte() << 8 | reader.readByte();
                    break;
                }
                case 253: {
                    value = reader.readByte() << 16 | reader.readByte() << 8 | reader.readByte();
                    break;
                }
                case 254: {
                    value = reader.readByte() << 24 | reader.readByte() << 16 | reader.readByte() << 8 | reader.readByte();
                    if (value + 251 >= 0) break;
                    throw new IllegalArgumentException("invalid unsigned int encoding with high bit set");
                }
                case 255: {
                    throw new IllegalArgumentException("invalid unsigned int encoding starting with 0xff");
                }
                default: {
                    return first;
                }
            }
            return value + 251;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("encoded value is truncated", e);
        }
    }

    public static int read(InputStream input) throws IOException {
        int first = input.read();
        if (first == -1) {
            throw new EOFException();
        }
        byte[] array = new byte[UnsignedIntEncoder.decodeLength(first)];
        array[0] = (byte)first;
        for (int i = 1; i < array.length; ++i) {
            int next = input.read();
            if (next == -1) {
                throw new EOFException();
            }
            array[i] = (byte)next;
        }
        return UnsignedIntEncoder.read(new ByteReader(array));
    }

    public static int read(ByteBuffer buf) {
        byte first = buf.get();
        byte[] array = new byte[UnsignedIntEncoder.decodeLength(first)];
        array[0] = first;
        if (array.length > 1) {
            buf.get(array, 1, array.length - 1);
        }
        return UnsignedIntEncoder.read(new ByteReader(array));
    }

    public static void skip(ByteReader reader) {
        int first = reader.readByte();
        if (first >= 251) {
            reader.skip(first - 251 + 1);
        }
    }

    public static int decodeLength(int first) {
        Preconditions.checkArgument(((first &= 0xFF) != 255 ? 1 : 0) != 0, (Object)"invalid unsigned int encoding starting with 0xff");
        return first < 251 ? 1 : first - 251 + 2;
    }

    public static int encodeLength(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"value < 0");
        if ((value -= 251) < 0) {
            return 1;
        }
        int length = 2;
        while ((value >>= 8) != 0) {
            ++length;
        }
        return length;
    }

    public static int encode(int value, byte[] buf, int off) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"value < 0");
        if (value < 251) {
            buf[off] = (byte)value;
            return 1;
        }
        value -= 251;
        int len = 1;
        int mask = -16777216;
        boolean encoding = false;
        int shift = 24;
        while (shift != 0) {
            if (encoding || (long)(value & mask) != 0L) {
                buf[off + len++] = (byte)(value >> shift);
                encoding = true;
            }
            shift -= 8;
            mask >>= 8;
        }
        buf[off + len++] = (byte)value;
        buf[off] = (byte)(251 + len - 2);
        return len;
    }

    public static void main(String[] args) {
        for (String arg : args) {
            byte[] bytes;
            block8: {
                bytes = null;
                try {
                    bytes = ByteUtil.parse(arg);
                }
                catch (IllegalArgumentException e) {
                    if (!arg.startsWith("0x")) break block8;
                    bytes = ByteUtil.parse(arg.substring(2));
                }
            }
            if (bytes != null) {
                System.out.println("Decoding bytes: " + ByteUtil.toString(bytes));
                try {
                    long value = UnsignedIntEncoder.decode(bytes);
                    System.out.println("0x" + ByteUtil.toString(bytes) + " decodes to " + value + " (" + String.format("0x%016x", value) + ")");
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                    System.out.println("Error decoding " + ByteUtil.toString(bytes) + ": " + e);
                }
            }
            Integer value = null;
            try {
                value = Integer.parseInt(arg);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (value == null || value < 0) continue;
            System.out.println("Encoding value " + value);
            ByteWriter writer = new ByteWriter();
            UnsignedIntEncoder.write(writer, (int)value);
            System.out.println(value + " (" + String.format("0x%016x", value) + ") encodes to " + ByteUtil.toString(writer.getBytes()));
        }
    }
}

