/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.ArrayList;
import java.util.List;
import org.jsimpledb.core.CompositeIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.CoreIndex3;
import org.jsimpledb.core.CoreIndex4;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.Index2View;
import org.jsimpledb.core.Index3View;
import org.jsimpledb.core.Index4View;
import org.jsimpledb.core.IndexStorageInfo;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.SchemaItem;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.KVStore;

class CompositeIndexStorageInfo
extends IndexStorageInfo {
    final List<Integer> storageIds;
    final List<FieldType<?>> fieldTypes;

    CompositeIndexStorageInfo(CompositeIndex index) {
        super(index.storageId);
        this.storageIds = new ArrayList<Integer>(index.fields.size());
        index.fields.stream().map(SchemaItem::getStorageId).forEach(this.storageIds::add);
        this.fieldTypes = new ArrayList(index.fields.size());
        index.fields.stream().map(SimpleField::getFieldType).map(FieldType::genericizeForIndex).forEach(this.fieldTypes::add);
    }

    Object getIndex(Transaction tx) {
        switch (this.storageIds.size()) {
            case 2: {
                return this.buildIndex(tx, this.fieldTypes.get(0), this.fieldTypes.get(1));
            }
            case 3: {
                return this.buildIndex(tx, this.fieldTypes.get(0), this.fieldTypes.get(1), this.fieldTypes.get(2));
            }
            case 4: {
                return this.buildIndex(tx, this.fieldTypes.get(0), this.fieldTypes.get(1), this.fieldTypes.get(2), this.fieldTypes.get(3));
            }
        }
        throw new RuntimeException("internal error");
    }

    private <V1, V2> CoreIndex2<V1, V2, ObjId> buildIndex(Transaction tx, FieldType<V1> value1Type, FieldType<V2> value2Type) {
        return new CoreIndex2<V1, V2, ObjId>((KVStore)tx.kvt, new Index2View<V1, V2, ObjId>(this.storageId, value1Type, value2Type, FieldTypeRegistry.OBJ_ID));
    }

    private <V1, V2, V3> CoreIndex3<V1, V2, V3, ObjId> buildIndex(Transaction tx, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<V3> value3Type) {
        return new CoreIndex3<V1, V2, V3, ObjId>((KVStore)tx.kvt, new Index3View<V1, V2, V3, ObjId>(this.storageId, value1Type, value2Type, value3Type, FieldTypeRegistry.OBJ_ID));
    }

    private <V1, V2, V3, V4> CoreIndex4<V1, V2, V3, V4, ObjId> buildIndex(Transaction tx, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<V3> value3Type, FieldType<V4> value4Type) {
        return new CoreIndex4<V1, V2, V3, V4, ObjId>((KVStore)tx.kvt, new Index4View<V1, V2, V3, V4, ObjId>(this.storageId, value1Type, value2Type, value3Type, value4Type, FieldTypeRegistry.OBJ_ID));
    }

    @Override
    public String toString() {
        return "composite index on fields " + this.fieldTypes;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompositeIndexStorageInfo that = (CompositeIndexStorageInfo)obj;
        return this.storageIds.equals(that.storageIds) && this.fieldTypes.equals(that.fieldTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.storageIds.hashCode() ^ this.fieldTypes.hashCode();
    }
}

