/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.NavigableMap;
import java.util.NavigableSet;
import org.jsimpledb.core.AbstractCoreIndex;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.Index2View;
import org.jsimpledb.core.IndexKeyFilter;
import org.jsimpledb.core.IndexMap;
import org.jsimpledb.core.IndexSet;
import org.jsimpledb.core.IndexView;
import org.jsimpledb.core.type.Tuple3FieldType;
import org.jsimpledb.index.Index;
import org.jsimpledb.index.Index2;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.tuple.Tuple2;
import org.jsimpledb.tuple.Tuple3;

public class CoreIndex2<V1, V2, T>
extends AbstractCoreIndex
implements Index2<V1, V2, T> {
    CoreIndex2(KVStore kv, Index2View<V1, V2, T> indexView) {
        super(kv, 3, indexView);
    }

    @Override
    public CoreIndex2<V1, V2, T> filter(int index, KeyFilter filter) {
        return new CoreIndex2<V1, V2, T>(this.kv, this.getIndex2View().filter(index, filter));
    }

    Index2View<V1, V2, T> getIndex2View() {
        return (Index2View)this.indexView;
    }

    public NavigableSet<Tuple3<V1, V2, T>> asSet() {
        Index2View<V1, V2, T> iv = this.getIndex2View();
        Tuple3FieldType<V1, V2, T> fieldType = new Tuple3FieldType<V1, V2, T>(iv.getValue1Type(), iv.getValue2Type(), iv.getTargetType());
        IndexSet indexSet = new IndexSet(this.kv, fieldType, iv.prefixMode, iv.prefix);
        if (iv.hasFilters()) {
            indexSet = indexSet.filterKeys(new IndexKeyFilter(this.kv, iv, 3));
        }
        return indexSet;
    }

    public NavigableMap<Tuple2<V1, V2>, NavigableSet<T>> asMap() {
        Index2View<V1, V2, T> iv = this.getIndex2View();
        IndexView<Tuple2<V1, V2>, T> tupleIV = iv.asTuple2IndexView();
        IndexMap indexMap = new IndexMap.OfValues<Tuple2<V1, V2>, T>(this.kv, tupleIV);
        if (tupleIV.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, tupleIV, 1));
        }
        return indexMap;
    }

    public NavigableMap<V1, Index<V2, T>> asMapOfIndex() {
        Index2View<V1, V2, T> iv = this.getIndex2View();
        IndexMap indexMap = new IndexMap.OfIndex<V1, V2, T>(this.kv, iv);
        if (iv.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, iv, 1));
        }
        return indexMap;
    }

    public CoreIndex<V1, V2> asIndex() {
        return new CoreIndex<V1, V2>(this.kv, this.getIndex2View().asIndexView());
    }
}

