/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldSwitch;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.StorageInfo;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.util.ObjIdMap;

public class CounterField
extends Field<Long> {
    CounterField(String name, int storageId, Schema schema) {
        super(name, storageId, schema, TypeToken.of(Long.class));
    }

    @Override
    public Long getValue(Transaction tx, ObjId id) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        return tx.readCounterField(id, this.storageId, false);
    }

    @Override
    public boolean hasDefaultValue(Transaction tx, ObjId id) {
        return this.getValue(tx, id) == 0L;
    }

    @Override
    public <R> R visit(FieldSwitch<R> target) {
        return target.caseCounterField(this);
    }

    @Override
    public String toString() {
        return "counter field `" + this.name + "'";
    }

    @Override
    void copy(ObjId srcId, ObjId dstId, Transaction srcTx, Transaction dstTx, ObjIdMap<ObjId> objectIdMap) {
        dstTx.writeCounterField(dstId, this.storageId, srcTx.readCounterField(srcId, this.storageId, false), false);
    }

    @Override
    StorageInfo toStorageInfo() {
        return null;
    }

    @Override
    boolean isUpgradeCompatible(Field<?> field) {
        return field.getClass() == this.getClass();
    }
}

