/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.InconsistentDatabaseException;
import org.jsimpledb.core.InvalidSchemaException;
import org.jsimpledb.core.Layout;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SchemaMismatchException;
import org.jsimpledb.core.Schemas;
import org.jsimpledb.core.SnapshotTransaction;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.jsimpledb.util.Diffs;
import org.jsimpledb.util.UnsignedIntEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database {
    public static final int MAX_INDEXED_FIELDS = 4;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FieldTypeRegistry fieldTypeRegistry = new FieldTypeRegistry();
    private final KVDatabase kvdb;
    private volatile Schemas lastSchemas;

    public Database(KVDatabase kvdb) {
        Preconditions.checkArgument((kvdb != null ? 1 : 0) != 0, (Object)"null kvdb");
        this.kvdb = kvdb;
    }

    public FieldTypeRegistry getFieldTypeRegistry() {
        return this.fieldTypeRegistry;
    }

    public KVDatabase getKVDatabase() {
        return this.kvdb;
    }

    public Transaction createTransaction(SchemaModel schemaModel, int version, boolean allowNewSchema) {
        return this.createTransaction(schemaModel, version, allowNewSchema, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction createTransaction(SchemaModel schemaModel, int version, boolean allowNewSchema, Map<String, ?> kvoptions) {
        KVTransaction kvt = this.kvdb.createTransaction(kvoptions);
        boolean success = false;
        try {
            Transaction tx = this.createTransaction(kvt, schemaModel, version, allowNewSchema);
            success = true;
            Transaction transaction = tx;
            return transaction;
        }
        finally {
            if (!success) {
                try {
                    kvt.rollback();
                }
                catch (KVTransactionException kVTransactionException) {}
            }
        }
    }

    public Transaction createTransaction(KVTransaction kvt, SchemaModel schemaModel, int version, boolean allowNewSchema) {
        Preconditions.checkArgument((kvt != null ? 1 : 0) != 0, (Object)"null kvt");
        Schemas schemas = this.verifySchemas((KVStore)kvt, schemaModel, version, allowNewSchema);
        assert (schemas != null);
        return version > 0 ? new Transaction(this, kvt, schemas, version) : new Transaction(this, kvt, schemas);
    }

    public SnapshotTransaction createSnapshotTransaction(KVStore kvstore, SchemaModel schemaModel, int version, boolean allowNewSchema) {
        Schemas schemas = this.verifySchemas(kvstore, schemaModel, version, allowNewSchema);
        assert (schemas != null);
        return version > 0 ? new SnapshotTransaction(this, kvstore, schemas, version) : new SnapshotTransaction(this, kvstore, schemas);
    }

    Schemas verifySchemas(KVStore kvstore, SchemaModel schemaModel, int version, boolean allowNewSchema) {
        int formatVersion;
        boolean uninitialized;
        Object pair;
        Preconditions.checkArgument((kvstore != null ? 1 : 0) != 0, (Object)"null kvstore");
        Preconditions.checkArgument((version >= -1 ? 1 : 0) != 0, (Object)("invalid schema version: " + version));
        Preconditions.checkArgument((schemaModel != null || version >= 0 ? 1 : 0) != 0, (Object)"can't auto-generate version without schema model");
        if (schemaModel != null) {
            schemaModel.validate();
            if (version == -1) {
                version = schemaModel.autogenerateVersion();
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("creating transaction using " + (version != 0 ? "schema version " + version : "highest recorded schema version"));
        }
        try (CloseableIterator metaDataIterator = kvstore.getRange(Layout.getMetaDataKeyRange());){
            Predicate<byte[]> userMetaData = key -> ByteUtil.isPrefixOf((byte[])Layout.getUserMetaDataKeyPrefix(), (byte[])key);
            byte[] formatVersionBytes = null;
            if (metaDataIterator.hasNext()) {
                pair = (KVPair)metaDataIterator.next();
                assert (Layout.getMetaDataKeyRange().contains(pair.getKey()));
                if (Arrays.equals(pair.getKey(), Layout.getFormatVersionKey())) {
                    formatVersionBytes = pair.getValue();
                } else if (!userMetaData.test(pair.getKey())) {
                    throw new InconsistentDatabaseException("database is uninitialized but contains unrecognized garbage (key " + ByteUtil.toString((byte[])pair.getKey()) + ")");
                }
            }
            boolean bl = uninitialized = formatVersionBytes == null;
            if (uninitialized) {
                KVPair first = kvstore.getAtLeast(new byte[0], null);
                KVPair last = kvstore.getAtMost(new byte[]{-1}, null);
                if (first != null && !userMetaData.test(first.getKey())) {
                    throw new InconsistentDatabaseException("database is uninitialized but contains unrecognized garbage (key " + ByteUtil.toString((byte[])first.getKey()) + ")");
                }
                if (last != null && !userMetaData.test(last.getKey())) {
                    throw new InconsistentDatabaseException("database is uninitialized but contains unrecognized garbage (key " + ByteUtil.toString((byte[])last.getKey()) + ")");
                }
                if (first != null != (last != null) || first != null && ByteUtil.compare((byte[])first.getKey(), (byte[])last.getKey()) > 0) {
                    throw new InconsistentDatabaseException("inconsistent results from getAtLeast() and getAtMost()");
                }
                try (CloseableIterator testIterator = kvstore.getRange(new byte[0], new byte[]{-1});){
                    if (testIterator.hasNext() ? first == null || !Arrays.equals(((KVPair)testIterator.next()).getKey(), first.getKey()) : first != null) {
                        throw new InconsistentDatabaseException("inconsistent results from getAtLeast() and getRange()");
                    }
                }
                testIterator = kvstore.getRange(new byte[0], new byte[]{-1}, true);
                var14_21 = null;
                try {
                    if (testIterator.hasNext() ? last == null || !Arrays.equals(((KVPair)testIterator.next()).getKey(), last.getKey()) : last != null) {
                        throw new InconsistentDatabaseException("inconsistent results from getAtMost() and getRange()");
                    }
                }
                catch (Throwable throwable) {
                    var14_21 = throwable;
                    throw throwable;
                }
                finally {
                    if (testIterator != null) {
                        if (var14_21 != null) {
                            try {
                                testIterator.close();
                            }
                            catch (Throwable throwable) {
                                var14_21.addSuppressed(throwable);
                            }
                        } else {
                            testIterator.close();
                        }
                    }
                }
                this.checkAddNewSchema(schemaModel, version, allowNewSchema);
                formatVersion = 2;
                this.log.debug("detected an uninitialized database; initializing now (format version " + formatVersion + ")");
                byte[] encodedFormatVersion = UnsignedIntEncoder.encode((int)formatVersion);
                kvstore.put(Layout.getFormatVersionKey(), encodedFormatVersion);
                formatVersionBytes = kvstore.get(Layout.getFormatVersionKey());
                if (formatVersionBytes == null || ByteUtil.compare((byte[])formatVersionBytes, (byte[])encodedFormatVersion) != 0) {
                    throw new InconsistentDatabaseException("database failed basic read/write test");
                }
                KVPair lower = kvstore.getAtLeast(new byte[0], null);
                if (lower == null || !lower.equals((Object)new KVPair(Layout.getFormatVersionKey(), encodedFormatVersion))) {
                    throw new InconsistentDatabaseException("database failed basic read/write test");
                }
                KVPair upper = kvstore.getAtMost(Layout.getUserMetaDataKeyPrefix(), null);
                if (upper == null || !upper.equals((Object)new KVPair(Layout.getFormatVersionKey(), encodedFormatVersion))) {
                    throw new InconsistentDatabaseException("database failed basic read/write test");
                }
            } else {
                try {
                    formatVersion = UnsignedIntEncoder.decode(formatVersionBytes);
                }
                catch (IllegalArgumentException e) {
                    throw new InconsistentDatabaseException("database contains invalid encoded format version " + ByteUtil.toString((byte[])formatVersionBytes) + " under key " + ByteUtil.toString((byte[])Layout.getFormatVersionKey()));
                }
                switch (formatVersion) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        throw new InconsistentDatabaseException("database contains unrecognized format version " + formatVersion + " under key " + ByteUtil.toString((byte[])Layout.getFormatVersionKey()));
                    }
                }
            }
            if (metaDataIterator.hasNext()) {
                pair = (KVPair)metaDataIterator.next();
                if (!Layout.getSchemaKeyRange().contains(pair.getKey())) {
                    throw new InconsistentDatabaseException("database contains unrecognized garbage at key " + ByteUtil.toString((byte[])pair.getKey()));
                }
            }
        }
        Schemas schemas = null;
        boolean firstAttempt = true;
        while (true) {
            TreeMap<Integer, byte[]> bytesMap = new TreeMap<Integer, byte[]>();
            CloseableIterator i = kvstore.getRange(Layout.getSchemaKeyRange());
            pair = null;
            try {
                while (i.hasNext()) {
                    KVPair pair2 = (KVPair)i.next();
                    assert (Layout.getSchemaKeyRange().contains(pair2.getKey()));
                    int vers = UnsignedIntEncoder.read((ByteReader)new ByteReader(pair2.getKey(), Layout.getSchemaKeyPrefix().length));
                    if (vers == 0) {
                        throw new InconsistentDatabaseException("database contains an invalid schema version zero");
                    }
                    bytesMap.put(vers, pair2.getValue());
                }
            }
            catch (Throwable throwable) {
                pair = throwable;
                throw throwable;
            }
            finally {
                if (i != null) {
                    if (pair != null) {
                        try {
                            i.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)pair).addSuppressed(throwable);
                        }
                    } else {
                        i.close();
                    }
                }
            }
            schemas = this.lastSchemas;
            if (schemas != null && !schemas.isSameVersions(bytesMap)) {
                schemas = null;
            }
            if (schemas == null) {
                try {
                    schemas = this.decodeSchemas(bytesMap, formatVersion);
                }
                catch (IllegalArgumentException e) {
                    if (firstAttempt) {
                        throw new InconsistentDatabaseException("database contains invalid schema information", e);
                    }
                    throw new InvalidSchemaException("schema is not valid: " + e.getMessage(), e);
                }
            }
            if (version == 0 && !bytesMap.isEmpty()) {
                version = bytesMap.lastKey();
            }
            if (bytesMap.containsKey(version)) {
                Diffs diffs;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("found schema version " + version + " in database; known versions are " + bytesMap.keySet());
                }
                SchemaModel dbSchemaModel = schemas.getVersion(version).getSchemaModel();
                if (schemaModel == null) break;
                if (!schemaModel.isCompatibleWith(dbSchemaModel)) {
                    diffs = schemaModel.differencesFrom(dbSchemaModel);
                    this.log.error("schema mismatch:\n=== Database schema ===\n{}\n=== Provided schema ===\n{}\n=== Differences ===\n{}", new Object[]{dbSchemaModel, schemaModel, diffs});
                    throw new IllegalArgumentException("the provided schema is not compatible with the schema already recorded in the database under version " + version + ":\n" + diffs);
                }
                if (!this.log.isTraceEnabled() || schemaModel.equals(dbSchemaModel)) break;
                diffs = schemaModel.differencesFrom(dbSchemaModel);
                this.log.trace("the provided schema differs from, but is compatible with, the database schema:\n{}", (Object)diffs);
                break;
            }
            if (bytesMap.isEmpty()) {
                if (!uninitialized) {
                    throw new InconsistentDatabaseException("database is initialized but contains no recorded schema versions");
                }
            } else {
                this.log.debug("schema version " + version + " not found in database; known versions are " + bytesMap.keySet());
            }
            this.checkAddNewSchema(schemaModel, version, allowNewSchema);
            this.log.debug("recording new schema version " + version + " into database");
            kvstore.put(Layout.getSchemaKey(version), Layout.encodeSchema(schemaModel, formatVersion));
            schemas = null;
            firstAttempt = false;
        }
        this.lastSchemas = schemas;
        return schemas;
    }

    public void validateSchema(SchemaModel schemaModel) {
        Database.validateSchema(this.getFieldTypeRegistry(), schemaModel);
    }

    public static void validateSchema(FieldTypeRegistry fieldTypeRegistry, SchemaModel schemaModel) {
        Preconditions.checkArgument((fieldTypeRegistry != null ? 1 : 0) != 0, (Object)"null fieldTypeRegistry");
        Preconditions.checkArgument((schemaModel != null ? 1 : 0) != 0, (Object)"null schemaModel");
        schemaModel.validate();
        try {
            new Schema(1, new byte[0], schemaModel, fieldTypeRegistry);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSchemaException("invalid schema: " + e.getMessage(), e);
        }
    }

    public static void validateSchemas(FieldTypeRegistry fieldTypeRegistry, Collection<SchemaModel> schemaModels) {
        Preconditions.checkArgument((fieldTypeRegistry != null ? 1 : 0) != 0, (Object)"null fieldTypeRegistry");
        Preconditions.checkArgument((schemaModels != null ? 1 : 0) != 0, (Object)"null schemaModels");
        TreeMap<Integer, Schema> schemaMap = new TreeMap<Integer, Schema>();
        int index = 0;
        for (SchemaModel schemaModel : schemaModels) {
            if (schemaModel == null) continue;
            schemaModel.validate();
            int version = index + 1;
            try {
                schemaMap.put(version, new Schema(version, new byte[0], schemaModel, fieldTypeRegistry));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidSchemaException("invalid schema at index " + index + ": " + e.getMessage(), e);
            }
            ++index;
        }
        try {
            new Schemas(schemaMap);
        }
        catch (InvalidSchemaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidSchemaException("invalid schema combination: " + e.getMessage(), e);
        }
    }

    private void checkAddNewSchema(SchemaModel schemaModel, int version, boolean allowNewSchema) {
        if (version == 0) {
            throw new SchemaMismatchException("database is uninitialized and no schema version was provided");
        }
        if (schemaModel == null) {
            throw new SchemaMismatchException("schema version " + version + " was not found in database, and no schema model was provided");
        }
        if (!allowNewSchema) {
            throw new SchemaMismatchException("schema version " + version + " was not found in database, and recording a new schema version is disabled in this transaction");
        }
    }

    private Schemas decodeSchemas(SortedMap<Integer, byte[]> bytesMap, int formatVersion) {
        TreeMap<Integer, Schema> versionMap = new TreeMap<Integer, Schema>();
        for (Map.Entry<Integer, byte[]> entry : bytesMap.entrySet()) {
            SchemaModel schemaModel;
            int version = entry.getKey();
            byte[] bytes = entry.getValue();
            try {
                schemaModel = Layout.decodeSchema(bytes, formatVersion);
            }
            catch (InvalidSchemaException e) {
                throw new InconsistentDatabaseException("found invalid schema version " + version + " recorded in database", e);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("read schema version {} from database:\n{}", (Object)version, (Object)schemaModel);
            }
            versionMap.put(version, new Schema(version, bytes, schemaModel, this.fieldTypeRegistry));
        }
        return new Schemas(versionMap);
    }
}

