/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import org.jsimpledb.core.CounterField;
import org.jsimpledb.core.EnumField;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.ListField;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.ReferenceField;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SetField;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.schema.CounterSchemaField;
import org.jsimpledb.schema.EnumSchemaField;
import org.jsimpledb.schema.ListSchemaField;
import org.jsimpledb.schema.MapSchemaField;
import org.jsimpledb.schema.ReferenceSchemaField;
import org.jsimpledb.schema.SchemaFieldSwitchAdapter;
import org.jsimpledb.schema.SetSchemaField;
import org.jsimpledb.schema.SimpleSchemaField;

class FieldBuilder
extends SchemaFieldSwitchAdapter<Field<?>> {
    final Schema schema;
    final FieldTypeRegistry fieldTypeRegistry;

    FieldBuilder(Schema schema, FieldTypeRegistry fieldTypeRegistry) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"null schema");
        Preconditions.checkArgument((fieldTypeRegistry != null ? 1 : 0) != 0, (Object)"null fieldTypeRegistry");
        this.schema = schema;
        this.fieldTypeRegistry = fieldTypeRegistry;
    }

    @Override
    public SetField<?> caseSetSchemaField(SetSchemaField field) {
        return this.buildSetField(field, (SimpleField)field.getElementField().visit(this));
    }

    @Override
    public ListField<?> caseListSchemaField(ListSchemaField field) {
        return this.buildListField(field, (SimpleField)field.getElementField().visit(this));
    }

    @Override
    public MapField<?, ?> caseMapSchemaField(MapSchemaField field) {
        return this.buildMapField(field, (SimpleField)field.getKeyField().visit(this), (SimpleField)field.getValueField().visit(this));
    }

    @Override
    public SimpleField<?> caseSimpleSchemaField(SimpleSchemaField field) {
        long signature;
        String fieldTypeName = field.getType();
        FieldType<?> fieldType = this.fieldTypeRegistry.getFieldType(fieldTypeName, signature = field.getEncodingSignature());
        if (fieldType == null) {
            StringBuilder buf = new StringBuilder("unknown field type `" + fieldTypeName + "'");
            if (signature != 0L) {
                buf.append(" with signature ").append(signature);
            }
            buf.append(" for field `").append(field.getName()).append('\'');
            boolean foundAny = false;
            for (FieldType<?> otherFieldType : this.fieldTypeRegistry.getAll()) {
                if (!otherFieldType.getName().equals(fieldTypeName)) continue;
                if (!foundAny) {
                    buf.append(" (note: field type(s) named `").append(fieldTypeName).append("' exist but with different signature(s): ");
                    foundAny = true;
                } else {
                    buf.append(", ");
                }
                buf.append(otherFieldType.getEncodingSignature());
            }
            if (foundAny) {
                buf.append(')');
            }
            throw new IllegalArgumentException(buf.toString());
        }
        return this.buildSimpleField(field, field.getName(), fieldType);
    }

    @Override
    public SimpleField<?> caseReferenceSchemaField(ReferenceSchemaField field) {
        Preconditions.checkArgument((field.getEncodingSignature() == 0L ? 1 : 0) != 0, (Object)"encoding signature must be zero");
        return new ReferenceField(field.getName(), field.getStorageId(), this.schema, field.getOnDelete(), field.isCascadeDelete(), field.isAllowDeleted(), field.isAllowDeletedSnapshot(), field.getObjectTypes());
    }

    @Override
    public EnumField caseEnumSchemaField(EnumSchemaField field) {
        Preconditions.checkArgument((field.getEncodingSignature() == 0L ? 1 : 0) != 0, (Object)"encoding signature must be zero");
        return new EnumField(field.getName(), field.getStorageId(), this.schema, field.isIndexed(), field.getIdentifiers());
    }

    @Override
    public CounterField caseCounterSchemaField(CounterSchemaField field) {
        return new CounterField(field.getName(), field.getStorageId(), this.schema);
    }

    private <T> SimpleField<T> buildSimpleField(SimpleSchemaField field, String fieldName, FieldType<T> fieldType) {
        assert (field.getEncodingSignature() == fieldType.getEncodingSignature());
        return new SimpleField<T>(fieldName, field.getStorageId(), this.schema, fieldType, field.isIndexed());
    }

    private <E> SetField<E> buildSetField(SetSchemaField field, SimpleField<E> elementField) {
        return new SetField<E>(field.getName(), field.getStorageId(), this.schema, elementField);
    }

    private <E> ListField<E> buildListField(ListSchemaField field, SimpleField<E> elementField) {
        return new ListField<E>(field.getName(), field.getStorageId(), this.schema, elementField);
    }

    private <K, V> MapField<K, V> buildMapField(MapSchemaField field, SimpleField<K> keyField, SimpleField<V> valueField) {
        return new MapField<K, V>(field.getName(), field.getStorageId(), this.schema, keyField, valueField);
    }
}

