/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.dellroad.stuff.java.Primitive;
import org.dellroad.stuff.java.PrimitiveSwitch;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.type.ArrayType;
import org.jsimpledb.core.type.BigDecimalType;
import org.jsimpledb.core.type.BigIntegerType;
import org.jsimpledb.core.type.BitSetType;
import org.jsimpledb.core.type.BooleanArrayType;
import org.jsimpledb.core.type.BooleanType;
import org.jsimpledb.core.type.ByteArrayType;
import org.jsimpledb.core.type.ByteType;
import org.jsimpledb.core.type.CharacterArrayType;
import org.jsimpledb.core.type.CharacterType;
import org.jsimpledb.core.type.DateType;
import org.jsimpledb.core.type.DoubleArrayType;
import org.jsimpledb.core.type.DoubleType;
import org.jsimpledb.core.type.DurationType;
import org.jsimpledb.core.type.FileType;
import org.jsimpledb.core.type.FloatArrayType;
import org.jsimpledb.core.type.FloatType;
import org.jsimpledb.core.type.Inet4AddressType;
import org.jsimpledb.core.type.Inet6AddressType;
import org.jsimpledb.core.type.InetAddressType;
import org.jsimpledb.core.type.InstantType;
import org.jsimpledb.core.type.IntegerArrayType;
import org.jsimpledb.core.type.IntegerType;
import org.jsimpledb.core.type.InternetAddressType;
import org.jsimpledb.core.type.LocalDateTimeType;
import org.jsimpledb.core.type.LocalDateType;
import org.jsimpledb.core.type.LocalTimeType;
import org.jsimpledb.core.type.LongArrayType;
import org.jsimpledb.core.type.LongType;
import org.jsimpledb.core.type.MonthDayType;
import org.jsimpledb.core.type.NullSafeType;
import org.jsimpledb.core.type.ObjIdType;
import org.jsimpledb.core.type.ObjectArrayType;
import org.jsimpledb.core.type.OffsetDateTimeType;
import org.jsimpledb.core.type.OffsetTimeType;
import org.jsimpledb.core.type.PatternType;
import org.jsimpledb.core.type.PeriodType;
import org.jsimpledb.core.type.PrimitiveWrapperType;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.core.type.ShortArrayType;
import org.jsimpledb.core.type.ShortType;
import org.jsimpledb.core.type.StringType;
import org.jsimpledb.core.type.URIType;
import org.jsimpledb.core.type.UUIDType;
import org.jsimpledb.core.type.UnsignedIntType;
import org.jsimpledb.core.type.VoidType;
import org.jsimpledb.core.type.YearMonthType;
import org.jsimpledb.core.type.YearType;
import org.jsimpledb.core.type.ZoneIdType;
import org.jsimpledb.core.type.ZoneOffsetType;
import org.jsimpledb.core.type.ZonedDateTimeType;

public class FieldTypeRegistry {
    public static final VoidType VOID = new VoidType();
    public static final PrimitiveWrapperType<Void> VOID_WRAPPER = new PrimitiveWrapperType<Void>(new VoidType());
    public static final BooleanType BOOLEAN = new BooleanType();
    public static final PrimitiveWrapperType<Boolean> BOOLEAN_WRAPPER = new PrimitiveWrapperType<Boolean>(BOOLEAN);
    public static final ByteType BYTE = new ByteType();
    public static final PrimitiveWrapperType<Byte> BYTE_WRAPPER = new PrimitiveWrapperType<Byte>(BYTE);
    public static final CharacterType CHARACTER = new CharacterType();
    public static final PrimitiveWrapperType<Character> CHARACTER_WRAPPER = new PrimitiveWrapperType<Character>(CHARACTER);
    public static final ShortType SHORT = new ShortType();
    public static final PrimitiveWrapperType<Short> SHORT_WRAPPER = new PrimitiveWrapperType<Short>(SHORT);
    public static final IntegerType INTEGER = new IntegerType();
    public static final PrimitiveWrapperType<Integer> INTEGER_WRAPPER = new PrimitiveWrapperType<Integer>(INTEGER);
    public static final FloatType FLOAT = new FloatType();
    public static final PrimitiveWrapperType<Float> FLOAT_WRAPPER = new PrimitiveWrapperType<Float>(FLOAT);
    public static final LongType LONG = new LongType();
    public static final PrimitiveWrapperType<Long> LONG_WRAPPER = new PrimitiveWrapperType<Long>(LONG);
    public static final DoubleType DOUBLE = new DoubleType();
    public static final PrimitiveWrapperType<Double> DOUBLE_WRAPPER = new PrimitiveWrapperType<Double>(DOUBLE);
    public static final ObjIdType OBJ_ID = new ObjIdType();
    public static final UnsignedIntType UNSIGNED_INT = new UnsignedIntType();
    public static final ReferenceFieldType REFERENCE = new ReferenceFieldType();
    public static final NullSafeType<String> STRING = new NullSafeType<String>(new StringType());
    private final HashMap<Key, FieldType<?>> types = new HashMap();
    private final HashMap<TypeToken<?>, ArrayList<FieldType<?>>> typesByType = new HashMap();

    public FieldTypeRegistry() {
        this.add(REFERENCE);
        this.add(VOID_WRAPPER);
        this.add(BOOLEAN);
        this.add(BOOLEAN_WRAPPER);
        this.add(BYTE);
        this.add(BYTE_WRAPPER);
        this.add(SHORT);
        this.add(SHORT_WRAPPER);
        this.add(CHARACTER);
        this.add(CHARACTER_WRAPPER);
        this.add(INTEGER);
        this.add(INTEGER_WRAPPER);
        this.add(FLOAT);
        this.add(FLOAT_WRAPPER);
        this.add(LONG);
        this.add(LONG_WRAPPER);
        this.add(DOUBLE);
        this.add(DOUBLE_WRAPPER);
        this.add(STRING);
        this.add(new FileType());
        this.add(new NullSafeType<BigDecimal>(new BigDecimalType()));
        this.add(new NullSafeType<BigInteger>(new BigIntegerType()));
        this.add(new NullSafeType<BitSet>(new BitSetType()));
        this.add(new NullSafeType<Date>(new DateType()));
        this.add(new NullSafeType<Duration>(new DurationType()));
        this.add(new NullSafeType<Inet4Address>(new Inet4AddressType()));
        this.add(new NullSafeType<Inet6Address>(new Inet6AddressType()));
        this.add(new NullSafeType<InetAddress>(new InetAddressType()));
        this.add(new NullSafeType<Instant>(new InstantType()));
        this.add(new NullSafeType<LocalDateTime>(new LocalDateTimeType()));
        this.add(new NullSafeType<LocalDate>(new LocalDateType()));
        this.add(new NullSafeType<LocalTime>(new LocalTimeType()));
        this.add(new NullSafeType<MonthDay>(new MonthDayType()));
        this.add(new NullSafeType<OffsetDateTime>(new OffsetDateTimeType()));
        this.add(new NullSafeType<OffsetTime>(new OffsetTimeType()));
        this.add(new NullSafeType<Period>(new PeriodType()));
        this.add(new NullSafeType<UUID>(new UUIDType()));
        this.add(new NullSafeType<YearMonth>(new YearMonthType()));
        this.add(new NullSafeType<Year>(new YearType()));
        this.add(new NullSafeType<ZoneOffset>(new ZoneOffsetType()));
        this.add(new NullSafeType<ZonedDateTime>(new ZonedDateTimeType()));
        this.add(new PatternType());
        this.add(new URIType());
        this.add(new ZoneIdType());
        try {
            this.add(new InternetAddressType());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void addNamedClasses(Iterable<String> classNames) {
        Preconditions.checkArgument((classNames != null ? 1 : 0) != 0, (Object)"null classNames");
        this.addClasses(StreamSupport.stream(classNames.spliterator(), false).map(className -> {
            try {
                return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).map(cl -> {
            try {
                return cl.asSubclass(FieldType.class);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(cl + " does not implement " + FieldType.class, e);
            }
        }).collect(Collectors.toList()));
    }

    public void addClasses(Iterable<? extends Class<? extends FieldType<?>>> classes) {
        Preconditions.checkArgument((classes != null ? 1 : 0) != 0, (Object)"null classes");
        for (Class<FieldType<?>> clazz : classes) {
            this.addClass(clazz);
        }
    }

    public void addClass(Class<? extends FieldType<?>> typeClass) {
        FieldType<?> fieldType;
        Preconditions.checkArgument((typeClass != null ? 1 : 0) != 0, (Object)"null typeClass");
        try {
            fieldType = typeClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't instantiate " + typeClass, e);
        }
        this.add(fieldType);
    }

    public synchronized boolean add(FieldType<?> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        Preconditions.checkArgument((!type.name.endsWith("[]") ? 1 : 0) != 0, (Object)("illegal array type name `" + type.name + "'"));
        Key key = type.toKey();
        FieldType<?> other = this.types.get(key);
        if (other != null) {
            if (other.equals(type)) {
                return false;
            }
            throw new IllegalArgumentException("type name `" + type.name + "'" + (type.signature != 0L ? " and encoding signature " + type.signature : "") + " conflicts with existing type " + other);
        }
        this.types.put(key, type);
        this.typesByType.computeIfAbsent(type.getTypeToken(), typeToken -> new ArrayList(1)).add(type);
        return true;
    }

    public FieldType<?> getFieldType(String name) {
        return this.getFieldType(name, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldType<?> getFieldType(String name, long signature) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        if (name.endsWith("[]")) {
            String elementName = name.substring(0, name.length() - "[]".length());
            FieldType<?> elementType = this.getFieldType(elementName, signature);
            if (elementType == null) {
                return null;
            }
            return this.getArrayType(elementType);
        }
        FieldTypeRegistry fieldTypeRegistry = this;
        synchronized (fieldTypeRegistry) {
            return this.types.get(new Key(name, signature));
        }
    }

    public <E> FieldType<E[]> getArrayType(final FieldType<E> elementType) {
        Preconditions.checkArgument((elementType != null ? 1 : 0) != 0, (Object)"null elementType");
        Primitive primitive = Primitive.get((Class)elementType.typeToken.getRawType());
        ObjectArrayType<E> notNullType = primitive == null ? this.createObjectArrayType(elementType) : (ArrayType)primitive.visit(new PrimitiveSwitch<ArrayType<?, ?>>(){

            public ArrayType<?, ?> caseVoid() {
                throw new IllegalArgumentException("cannot create array of type `" + elementType.name + "'");
            }

            public ArrayType<?, ?> caseBoolean() {
                return new BooleanArrayType();
            }

            public ArrayType<?, ?> caseByte() {
                return new ByteArrayType();
            }

            public ArrayType<?, ?> caseCharacter() {
                return new CharacterArrayType();
            }

            public ArrayType<?, ?> caseShort() {
                return new ShortArrayType();
            }

            public ArrayType<?, ?> caseInteger() {
                return new IntegerArrayType();
            }

            public ArrayType<?, ?> caseFloat() {
                return new FloatArrayType();
            }

            public ArrayType<?, ?> caseLong() {
                return new LongArrayType();
            }

            public ArrayType<?, ?> caseDouble() {
                return new DoubleArrayType();
            }
        });
        return this.createNullSafeType(notNullType);
    }

    public synchronized <T> List<FieldType<T>> getFieldTypes(TypeToken<T> typeToken) {
        Preconditions.checkArgument((typeToken != null ? 1 : 0) != 0, (Object)"null typeToken");
        TypeToken elementTypeToken = typeToken.getComponentType();
        if (elementTypeToken != null) {
            ArrayList fieldTypes = this.getFieldTypes(elementTypeToken).stream().map(elementFieldType -> this.getArrayType(this.getFieldType(elementTypeToken))).collect(Collectors.toCollection(ArrayList::new));
            return Collections.unmodifiableList(fieldTypes);
        }
        ArrayList<FieldType<?>> fieldTypes = this.typesByType.get(typeToken);
        return fieldTypes != null ? Collections.unmodifiableList(fieldTypes) : Collections.emptyList();
    }

    public <T> FieldType<T> getFieldType(TypeToken<T> typeToken) {
        List<FieldType<T>> fieldTypes = this.getFieldTypes(typeToken);
        switch (fieldTypes.size()) {
            case 0: {
                throw new IllegalArgumentException("no registered types support values of type " + typeToken);
            }
            case 1: {
                return fieldTypes.get(0);
            }
        }
        throw new IllegalArgumentException("multiple registered types support values of type " + typeToken + ": " + fieldTypes);
    }

    public synchronized List<FieldType<?>> getAll() {
        return new ArrayList(this.types.values());
    }

    private <E> ObjectArrayType<E> createObjectArrayType(FieldType<E> elementType) {
        return new ObjectArrayType<E>(elementType);
    }

    private <T> NullSafeType<T> createNullSafeType(FieldType<T> notNullType) {
        return new NullSafeType<T>(notNullType);
    }

    static class Key {
        private final String name;
        private final long signature;

        Key(String name, long signature) {
            this.name = name;
            this.signature = signature;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Key that = (Key)obj;
            return this.name.equals(that.name) && this.signature == that.signature;
        }

        public int hashCode() {
            return this.name.hashCode() ^ Long.hashCode(this.signature);
        }
    }
}

