/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.util.AbstractKVNavigableSet;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;

abstract class FieldTypeSet<E>
extends AbstractKVNavigableSet<E> {
    final FieldType<E> fieldType;
    final byte[] prefix;

    FieldTypeSet(KVStore kv, FieldType<E> fieldType, boolean prefixMode, byte[] prefix) {
        this(kv, fieldType, prefixMode, false, prefix, KeyRange.forPrefix((byte[])prefix), null, new Bounds());
    }

    FieldTypeSet(KVStore kv, FieldType<E> fieldType, boolean prefixMode, boolean reversed, byte[] prefix, KeyRange keyRange, KeyFilter keyFilter, Bounds<E> bounds) {
        super(kv, prefixMode, reversed, keyRange, keyFilter, bounds);
        Preconditions.checkArgument((fieldType != null ? 1 : 0) != 0, (Object)"null fieldType");
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"null prefix");
        Preconditions.checkArgument((prefix.length == 0 || keyRange != null ? 1 : 0) != 0, (Object)"null keyRange");
        if (keyRange != null && !KeyRange.forPrefix((byte[])prefix).contains(keyRange)) {
            throw new IllegalArgumentException(keyRange + " does not restrict to prefix " + ByteUtil.toString((byte[])prefix));
        }
        this.fieldType = fieldType;
        this.prefix = prefix;
    }

    public final Comparator<? super E> comparator() {
        return this.reversed ? Collections.reverseOrder(this.fieldType) : this.fieldType;
    }

    protected void encode(ByteWriter writer, Object obj) {
        writer.write(this.prefix);
        this.fieldType.validateAndWrite(writer, obj);
    }

    protected E decode(ByteReader reader) {
        assert (ByteUtil.isPrefixOf((byte[])this.prefix, (byte[])reader.getBytes()));
        reader.skip(this.prefix.length);
        return this.fieldType.read(reader);
    }
}

