/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import org.jsimpledb.core.AbstractIndexView;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypesFilter;
import org.jsimpledb.core.Index2View;
import org.jsimpledb.core.Index3View;
import org.jsimpledb.core.IndexView;
import org.jsimpledb.core.type.Tuple2FieldType;
import org.jsimpledb.core.type.Tuple3FieldType;
import org.jsimpledb.core.type.Tuple4FieldType;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.tuple.Tuple2;
import org.jsimpledb.tuple.Tuple3;
import org.jsimpledb.tuple.Tuple4;
import org.jsimpledb.util.UnsignedIntEncoder;

class Index4View<V1, V2, V3, V4, T>
extends AbstractIndexView {
    Index4View(int storageId, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<V3> value3Type, FieldType<V4> value4Type, FieldType<T> targetType) {
        this(UnsignedIntEncoder.encode((int)storageId), false, value1Type, value2Type, value3Type, value4Type, targetType);
    }

    Index4View(byte[] prefix, boolean prefixMode, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<V3> value3Type, FieldType<V4> value4Type, FieldType<T> targetType) {
        super(prefix, prefixMode, value1Type, value2Type, value3Type, value4Type, targetType);
    }

    private Index4View(Index4View<V1, V2, V3, V4, T> original) {
        super(original);
    }

    public FieldType<V1> getValue1Type() {
        return this.fieldTypes[0];
    }

    public FieldType<V2> getValue2Type() {
        return this.fieldTypes[1];
    }

    public FieldType<V3> getValue3Type() {
        return this.fieldTypes[2];
    }

    public FieldType<V4> getValue4Type() {
        return this.fieldTypes[3];
    }

    public FieldType<T> getTargetType() {
        return this.fieldTypes[4];
    }

    @Override
    public Index4View<V1, V2, V3, V4, T> filter(int index, KeyFilter keyFilter) {
        return (Index4View)super.filter(index, keyFilter);
    }

    @Override
    protected Index4View<V1, V2, V3, V4, T> copy() {
        return new Index4View<V1, V2, V3, V4, T>(this);
    }

    public IndexView<Tuple4<V1, V2, V3, V4>, T> asTuple4IndexView() {
        AbstractIndexView indexView = new IndexView(this.prefix, this.prefixMode, new Tuple4FieldType<V1, V2, V3, V4>(this.getValue1Type(), this.getValue2Type(), this.getValue3Type(), this.getValue4Type()), this.getTargetType());
        KeyFilter value1Filter = this.getFilter(0);
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter value3Filter = this.getFilter(2);
        KeyFilter value4Filter = this.getFilter(3);
        KeyFilter targetFilter = this.getFilter(4);
        if (value1Filter != null || value2Filter != null || value3Filter != null || value4Filter != null) {
            FieldTypesFilter tupleFilter = new FieldTypesFilter(null, this.getValue1Type(), this.getValue2Type(), this.getValue3Type(), this.getValue4Type());
            if (value1Filter != null) {
                tupleFilter = tupleFilter.filter(0, value1Filter);
            }
            if (value2Filter != null) {
                tupleFilter = tupleFilter.filter(1, value2Filter);
            }
            if (value3Filter != null) {
                tupleFilter = tupleFilter.filter(2, value3Filter);
            }
            if (value4Filter != null) {
                tupleFilter = tupleFilter.filter(3, value4Filter);
            }
            indexView = ((IndexView)indexView).filter(0, tupleFilter);
        }
        if (targetFilter != null) {
            indexView = ((IndexView)indexView).filter(1, targetFilter);
        }
        return indexView;
    }

    public Index2View<Tuple3<V1, V2, V3>, V4, T> asTuple3Index2View() {
        AbstractIndexView indexView = new Index2View(this.prefix, this.prefixMode, new Tuple3FieldType<V1, V2, V3>(this.getValue1Type(), this.getValue2Type(), this.getValue3Type()), this.getValue4Type(), this.getTargetType());
        KeyFilter value1Filter = this.getFilter(0);
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter value3Filter = this.getFilter(2);
        KeyFilter value4Filter = this.getFilter(3);
        KeyFilter targetFilter = this.getFilter(4);
        if (value1Filter != null || value2Filter != null || value3Filter != null) {
            FieldTypesFilter tupleFilter = new FieldTypesFilter(null, this.getValue1Type(), this.getValue2Type(), this.getValue3Type());
            if (value1Filter != null) {
                tupleFilter = tupleFilter.filter(0, value1Filter);
            }
            if (value2Filter != null) {
                tupleFilter = tupleFilter.filter(1, value2Filter);
            }
            if (value3Filter != null) {
                tupleFilter = tupleFilter.filter(2, value3Filter);
            }
            indexView = ((Index2View)indexView).filter(0, tupleFilter);
        }
        if (value4Filter != null) {
            indexView = ((Index2View)indexView).filter(1, value4Filter);
        }
        if (targetFilter != null) {
            indexView = ((Index2View)indexView).filter(2, targetFilter);
        }
        return indexView;
    }

    public Index3View<Tuple2<V1, V2>, V3, V4, T> asTuple2Index3View() {
        AbstractIndexView indexView = new Index3View(this.prefix, this.prefixMode, new Tuple2FieldType<V1, V2>(this.getValue1Type(), this.getValue2Type()), this.getValue3Type(), this.getValue4Type(), this.getTargetType());
        KeyFilter value1Filter = this.getFilter(0);
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter value3Filter = this.getFilter(2);
        KeyFilter value4Filter = this.getFilter(3);
        KeyFilter targetFilter = this.getFilter(4);
        if (value1Filter != null || value2Filter != null) {
            FieldTypesFilter tupleFilter = new FieldTypesFilter(null, this.getValue1Type(), this.getValue2Type());
            if (value1Filter != null) {
                tupleFilter = tupleFilter.filter(0, value1Filter);
            }
            if (value2Filter != null) {
                tupleFilter = tupleFilter.filter(1, value2Filter);
            }
            indexView = ((Index3View)indexView).filter(0, tupleFilter);
        }
        if (value3Filter != null) {
            indexView = ((Index3View)indexView).filter(1, value3Filter);
        }
        if (value4Filter != null) {
            indexView = ((Index3View)indexView).filter(2, value4Filter);
        }
        if (targetFilter != null) {
            indexView = ((Index3View)indexView).filter(3, targetFilter);
        }
        return indexView;
    }

    public Index3View<V1, V2, V3, V4> asIndex3View() {
        AbstractIndexView indexView = new Index3View<V1, V2, V3, V4>(this.prefix, true, this.getValue1Type(), this.getValue2Type(), this.getValue3Type(), this.getValue4Type());
        KeyFilter value1Filter = this.getFilter(0);
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter value3Filter = this.getFilter(2);
        KeyFilter value4Filter = this.getFilter(3);
        if (value1Filter != null) {
            indexView = indexView.filter(0, value1Filter);
        }
        if (value2Filter != null) {
            indexView = indexView.filter(1, value2Filter);
        }
        if (value3Filter != null) {
            indexView = indexView.filter(2, value3Filter);
        }
        if (value4Filter != null) {
            indexView = indexView.filter(3, value4Filter);
        }
        return indexView;
    }

    public Index3View<V2, V3, V4, T> asIndex3View(byte[] keyPrefix) {
        AbstractIndexView indexView = new Index3View<V2, V3, V4, T>(keyPrefix, this.prefixMode, this.getValue2Type(), this.getValue3Type(), this.getValue4Type(), this.getTargetType());
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter value3Filter = this.getFilter(2);
        KeyFilter value4Filter = this.getFilter(3);
        KeyFilter targetFilter = this.getFilter(4);
        if (value2Filter != null) {
            indexView = indexView.filter(0, value2Filter);
        }
        if (value3Filter != null) {
            indexView = indexView.filter(1, value3Filter);
        }
        if (value4Filter != null) {
            indexView = indexView.filter(2, value4Filter);
        }
        if (targetFilter != null) {
            indexView = indexView.filter(3, targetFilter);
        }
        return indexView;
    }
}

