/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.NavigableMap;
import java.util.NavigableSet;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.CoreIndex3;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypeMap;
import org.jsimpledb.core.Index2View;
import org.jsimpledb.core.Index3View;
import org.jsimpledb.core.Index4View;
import org.jsimpledb.core.IndexKeyFilter;
import org.jsimpledb.core.IndexSet;
import org.jsimpledb.core.IndexView;
import org.jsimpledb.index.Index;
import org.jsimpledb.index.Index2;
import org.jsimpledb.index.Index3;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;

abstract class IndexMap<K, V>
extends FieldTypeMap<K, V> {
    private IndexMap(KVStore kv, FieldType<K> keyType, byte[] prefix) {
        super(kv, keyType, true, prefix);
    }

    private IndexMap(KVStore kv, FieldType<K> keyType, boolean reversed, byte[] prefix, KeyRange keyRange, KeyFilter keyFilter, Bounds<K> bounds) {
        super(kv, keyType, true, reversed, prefix, keyRange, keyFilter, bounds);
    }

    public String getDescription() {
        return "IndexMap[prefix=" + ByteUtil.toString((byte[])this.prefix) + ",keyType=" + this.keyFieldType + (this.bounds != null ? ",bounds=" + this.bounds : "") + (this.keyRange != null ? ",keyRange=" + this.keyRange : "") + (this.keyFilter != null ? ",keyFilter=" + this.keyFilter : "") + (this.reversed ? ",reversed" : "") + "]";
    }

    public IndexMap<K, V> filterKeys(KeyFilter keyFilter) {
        return (IndexMap)((Object)super.filterKeys(keyFilter));
    }

    protected V decodeValue(KVPair pair) {
        ByteReader reader = new ByteReader(pair.getKey());
        assert (ByteUtil.isPrefixOf((byte[])this.prefix, (byte[])reader.getBytes()));
        reader.skip(this.prefix.length);
        this.keyFieldType.skip(reader);
        return this.decodeValue(reader.getBytes(0, reader.getOffset()));
    }

    protected abstract V decodeValue(byte[] var1);

    static class OfIndex3<V1, V2, V3, V4, T>
    extends IndexMap<V1, Index3<V2, V3, V4, T>> {
        private final Index4View<V1, V2, V3, V4, T> indexView;

        OfIndex3(KVStore kv, Index4View<V1, V2, V3, V4, T> indexView) {
            super(kv, indexView.getValue1Type(), indexView.prefix);
            this.indexView = indexView;
        }

        private OfIndex3(KVStore kv, Index4View<V1, V2, V3, V4, T> indexView, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<V1> bounds) {
            super(kv, indexView.getValue1Type(), reversed, indexView.prefix, keyRange, keyFilter, bounds);
            this.indexView = indexView;
        }

        protected NavigableMap<V1, Index3<V2, V3, V4, T>> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<V1> newBounds) {
            return new OfIndex3<V1, V2, V3, V4, T>(this.kv, this.indexView, newReversed, newKeyRange, newKeyFilter, newBounds);
        }

        @Override
        protected CoreIndex3<V2, V3, V4, T> decodeValue(byte[] keyPrefix) {
            return new CoreIndex3<V2, V3, V4, T>(this.kv, this.indexView.asIndex3View(keyPrefix));
        }
    }

    static class OfIndex2<V1, V2, V3, T>
    extends IndexMap<V1, Index2<V2, V3, T>> {
        private final Index3View<V1, V2, V3, T> indexView;

        OfIndex2(KVStore kv, Index3View<V1, V2, V3, T> indexView) {
            super(kv, indexView.getValue1Type(), indexView.prefix);
            this.indexView = indexView;
        }

        private OfIndex2(KVStore kv, Index3View<V1, V2, V3, T> indexView, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<V1> bounds) {
            super(kv, indexView.getValue1Type(), reversed, indexView.prefix, keyRange, keyFilter, bounds);
            this.indexView = indexView;
        }

        protected NavigableMap<V1, Index2<V2, V3, T>> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<V1> newBounds) {
            return new OfIndex2<V1, V2, V3, T>(this.kv, this.indexView, newReversed, newKeyRange, newKeyFilter, newBounds);
        }

        @Override
        protected CoreIndex2<V2, V3, T> decodeValue(byte[] keyPrefix) {
            return new CoreIndex2<V2, V3, T>(this.kv, this.indexView.asIndex2View(keyPrefix));
        }
    }

    static class OfIndex<V1, V2, T>
    extends IndexMap<V1, Index<V2, T>> {
        private final Index2View<V1, V2, T> indexView;

        OfIndex(KVStore kv, Index2View<V1, V2, T> indexView) {
            super(kv, indexView.getValue1Type(), indexView.prefix);
            this.indexView = indexView;
        }

        private OfIndex(KVStore kv, Index2View<V1, V2, T> indexView, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<V1> bounds) {
            super(kv, indexView.getValue1Type(), reversed, indexView.prefix, keyRange, keyFilter, bounds);
            this.indexView = indexView;
        }

        protected NavigableMap<V1, Index<V2, T>> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<V1> newBounds) {
            return new OfIndex<V1, V2, T>(this.kv, this.indexView, newReversed, newKeyRange, newKeyFilter, newBounds);
        }

        @Override
        protected CoreIndex<V2, T> decodeValue(byte[] keyPrefix) {
            return new CoreIndex<V2, T>(this.kv, this.indexView.asIndexView(keyPrefix));
        }
    }

    static class OfValues<V, E>
    extends IndexMap<V, NavigableSet<E>> {
        private final IndexView<V, E> indexView;

        OfValues(KVStore kv, IndexView<V, E> indexView) {
            super(kv, indexView.getValueType(), indexView.prefix);
            this.indexView = indexView;
        }

        private OfValues(KVStore kv, IndexView<V, E> indexView, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<V> bounds) {
            super(kv, indexView.getValueType(), reversed, indexView.prefix, keyRange, keyFilter, bounds);
            this.indexView = indexView;
        }

        protected NavigableMap<V, NavigableSet<E>> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<V> newBounds) {
            return new OfValues<V, E>(this.kv, this.indexView, newReversed, newKeyRange, newKeyFilter, newBounds);
        }

        @Override
        protected NavigableSet<E> decodeValue(byte[] keyPrefix) {
            IndexSet<E> indexSet = new IndexSet<E>(this.kv, this.indexView.getTargetType(), this.indexView.prefixMode, keyPrefix);
            KeyFilter targetFilter = this.indexView.getFilter(1);
            if (targetFilter != null) {
                indexSet = indexSet.filterKeys(new IndexKeyFilter(this.kv, keyPrefix, new FieldType[]{this.indexView.getTargetType()}, new KeyFilter[]{targetFilter}, 1));
            }
            return indexSet;
        }
    }
}

