/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.Set;
import java.util.function.Predicate;
import org.jsimpledb.core.ComplexSubFieldStorageInfo;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypeMap;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.Index2View;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.KVPairIterator;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.util.ByteReader;

class MapValueStorageInfo<K, V>
extends ComplexSubFieldStorageInfo<V, MapField<K, V>> {
    final FieldType<K> keyFieldType;

    MapValueStorageInfo(MapField<K, V> field) {
        super(field.valueField, field);
        this.keyFieldType = field.keyField.fieldType.genericizeForIndex();
    }

    CoreIndex2<V, ObjId, K> getValueIndex(Transaction tx) {
        return new CoreIndex2((KVStore)tx.kvt, new Index2View(this.storageId, this.fieldType, FieldTypeRegistry.OBJ_ID, this.keyFieldType));
    }

    @Override
    CoreIndex<V, ObjId> getIndex(Transaction tx) {
        return this.getValueIndex(tx).asIndex();
    }

    @Override
    void unreference(Transaction tx, ObjId target, ObjId referrer, byte[] prefix) {
        FieldTypeMap fieldMap = (FieldTypeMap)((Object)tx.readMapField(referrer, ((MapField)this.parentRepresentative).storageId, false));
        KVPairIterator i = new KVPairIterator((KVStore)tx.kvt, prefix);
        while (i.hasNext()) {
            ByteReader reader = new ByteReader(i.next().getKey());
            reader.skip(prefix.length);
            fieldMap.remove(fieldMap.keyFieldType.read(reader));
        }
    }

    @Override
    void readAllNonNull(Transaction tx, ObjId target, Set<V> values, Predicate<? super V> filter) {
        for (Object value : ((MapField)this.parentRepresentative).getValueInternal(tx, target).values()) {
            if (value == null || filter != null && !filter.test(value)) continue;
            values.add(value);
        }
    }

    @Override
    public String toString() {
        return "map value field with " + this.fieldType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MapValueStorageInfo that = (MapValueStorageInfo)obj;
        return this.keyFieldType.equals(that.keyFieldType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.keyFieldType.hashCode();
    }
}

