/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.UnsignedIntEncoder;

@Immutable
public class ObjId
implements Comparable<ObjId>,
Serializable {
    public static final int NUM_BYTES = 8;
    public static final Pattern PATTERN = Pattern.compile("\\p{XDigit}{16}");
    private static final long serialVersionUID = 1598203254073015116L;
    private static final ThreadLocal<SecureRandom> RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    private final long value;

    public ObjId(int storageId) {
        this(ObjId.buildRandom(storageId));
    }

    public ObjId(String string) {
        this(ObjId.parseString(string));
    }

    public ObjId(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"null reader");
        this.value = ByteUtil.readLong((ByteReader)reader);
        this.validateStorageId();
    }

    public ObjId(long value) {
        this.value = value;
        this.validateStorageId();
    }

    private void validateStorageId() {
        int storageId;
        try {
            storageId = this.getStorageId();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid object ID", e);
        }
        Preconditions.checkArgument((storageId > 0 ? 1 : 0) != 0, (Object)"invalid object ID containing non-positive storage ID");
    }

    public int getStorageId() {
        return UnsignedIntEncoder.read((ByteReader)new ByteReader(this.getBytes()));
    }

    public byte[] getBytes() {
        ByteWriter writer = new ByteWriter(8);
        this.writeTo(writer);
        return writer.getBytes();
    }

    public long asLong() {
        return this.value;
    }

    public void writeTo(ByteWriter writer) {
        ByteUtil.writeLong((ByteWriter)writer, (long)this.value);
    }

    public static ObjId getMin(int storageId) {
        return ObjId.getFill(storageId, 0);
    }

    public static ObjId getMax(int storageId) {
        return ObjId.getFill(storageId, 255);
    }

    public static KeyRange getKeyRange(int storageId) {
        Preconditions.checkArgument((storageId > 0 ? 1 : 0) != 0, (Object)"invalid non-positive storage ID");
        ByteWriter writer = new ByteWriter(8);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)storageId);
        return KeyRange.forPrefix((byte[])writer.getBytes());
    }

    private static ObjId getFill(int storageId, int value) {
        Preconditions.checkArgument((storageId > 0 ? 1 : 0) != 0, (Object)"invalid non-positive storage ID");
        ByteWriter writer = new ByteWriter(8);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)storageId);
        for (int remain = 8 - writer.getLength(); remain > 0; --remain) {
            writer.writeByte(value);
        }
        return new ObjId(new ByteReader(writer));
    }

    public String toString() {
        ByteWriter writer = new ByteWriter(8);
        this.writeTo(writer);
        byte[] buf = writer.getBytes();
        char[] result = new char[16];
        int off = 0;
        for (byte b : buf) {
            result[off++] = Character.forDigit(b >> 4 & 0xF, 16);
            result[off++] = Character.forDigit(b & 0xF, 16);
        }
        return new String(result);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ObjId that = (ObjId)obj;
        return this.value == that.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public int compareTo(ObjId that) {
        return ByteUtil.compare((byte[])this.getBytes(), (byte[])that.getBytes());
    }

    private static ByteReader buildRandom(int storageId) {
        if (storageId <= 0) {
            throw new IllegalArgumentException("invalid storage ID " + storageId);
        }
        ByteWriter writer = new ByteWriter(8);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)storageId);
        byte[] randomPart = new byte[8 - writer.getLength()];
        RANDOM.get().nextBytes(randomPart);
        writer.write(randomPart);
        return new ByteReader(writer);
    }

    private static ByteReader parseString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        if (string.length() != 16) {
            throw new IllegalArgumentException("invalid object ID `" + string + "'");
        }
        byte[] buf = new byte[8];
        int off = 0;
        for (int i = 0; i < buf.length; ++i) {
            int digit1 = Character.digit(string.charAt(off++), 16);
            int digit2 = Character.digit(string.charAt(off++), 16);
            if (digit1 == -1 || digit2 == -1) {
                throw new IllegalArgumentException("invalid object ID `" + string + "'");
            }
            buf[i] = (byte)(digit1 << 4 | digit2);
        }
        return new ByteReader(buf);
    }
}

