/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.InconsistentDatabaseException;
import org.jsimpledb.core.InvalidObjectVersionException;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.UnsignedIntEncoder;

class ObjInfo {
    private static final int META_DATA_VERSION = 1;
    final Transaction tx;
    final ObjId id;
    final int version;
    final boolean deleteNotified;
    Schema schema;
    ObjType objType;

    ObjInfo(Transaction tx, ObjId id) {
        assert (tx != null);
        assert (id != null);
        this.tx = tx;
        this.id = id;
        byte[] value = tx.kvt.get(this.id.getBytes());
        if (value == null) {
            throw new DeletedObjectException(tx, this.id);
        }
        ByteReader reader = new ByteReader(value);
        int metaDataVersion = UnsignedIntEncoder.read((ByteReader)reader);
        if (metaDataVersion != 1) {
            throw new InconsistentDatabaseException("found unknown object meta-data version " + metaDataVersion + " in " + this.id);
        }
        this.version = UnsignedIntEncoder.read((ByteReader)reader);
        if (this.version == 0) {
            throw new InvalidObjectVersionException(this.id, this.version);
        }
        this.deleteNotified = FieldTypeRegistry.BOOLEAN.read(reader);
    }

    ObjInfo(Transaction tx, ObjId id, int version, boolean deleteNotified, Schema schema, ObjType objType) {
        assert (tx != null);
        assert (id != null);
        this.tx = tx;
        this.id = id;
        this.version = version;
        this.deleteNotified = deleteNotified;
        this.schema = schema;
        this.objType = objType;
    }

    public ObjId getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDeleteNotified() {
        return this.deleteNotified;
    }

    public Schema getSchema() {
        if (this.schema == null) {
            try {
                this.schema = this.tx.schemas.getVersion(this.version);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidObjectVersionException(this.id, this.version);
            }
        }
        return this.schema;
    }

    public ObjType getObjType() {
        if (this.objType == null) {
            try {
                this.objType = this.getSchema().getObjType(this.id.getStorageId());
            }
            catch (IllegalArgumentException e) {
                throw new InconsistentDatabaseException("object " + this.id + " has invalid storage ID", e);
            }
        }
        return this.objType;
    }

    public static void write(Transaction tx, ObjId id, int version, boolean deleteNotified) {
        ByteWriter writer = new ByteWriter();
        UnsignedIntEncoder.write((ByteWriter)writer, (int)1);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)version);
        FieldTypeRegistry.BOOLEAN.write(writer, deleteNotified);
        tx.kvt.put(id.getBytes(), writer.getBytes());
    }

    public String toString() {
        return "ObjInfo[id=" + this.id + ",version=" + this.version + (this.deleteNotified ? ",deleteNotified" : "") + ",schema=" + this.schema + ",objType=" + this.objType + "]";
    }
}

