/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.NavigableSet;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.FieldTypeSet;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.ByteUtil;

final class ObjTypeSet
extends FieldTypeSet<ObjId> {
    private final Transaction tx;

    ObjTypeSet(Transaction tx, int storageId) {
        super((KVStore)tx.kvt, FieldTypeRegistry.OBJ_ID, true, false, ByteUtil.EMPTY, ObjId.getKeyRange(storageId), null, new Bounds((Object)ObjId.getMin(storageId), (Object)ObjId.getMin(storageId + 1)));
        this.tx = tx;
    }

    ObjTypeSet(Transaction tx) {
        super((KVStore)tx.kvt, FieldTypeRegistry.OBJ_ID, true, false, ByteUtil.EMPTY, null, (KeyFilter)tx.schemas.objTypesKeyRanges, new Bounds());
        this.tx = tx;
    }

    private ObjTypeSet(Transaction tx, boolean reversed, byte[] prefix, KeyRange keyRange, KeyFilter keyFilter, Bounds<ObjId> bounds) {
        super((KVStore)tx.kvt, FieldTypeRegistry.OBJ_ID, true, reversed, prefix, keyRange, keyFilter, bounds);
        this.tx = tx;
    }

    public boolean remove(Object obj) {
        if (!(obj instanceof ObjId)) {
            return false;
        }
        ObjId id = (ObjId)obj;
        if (!this.isVisible(id.getBytes())) {
            return false;
        }
        return this.tx.delete(id);
    }

    protected NavigableSet<ObjId> createSubSet(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<ObjId> newBounds) {
        return new ObjTypeSet(this.tx, newReversed, this.prefix, newKeyRange, newKeyFilter, newBounds);
    }
}

