/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.SimpleFieldStorageInfo;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.type.ReferenceFieldType;

class RegularSimpleFieldStorageInfo<T>
extends SimpleFieldStorageInfo<T> {
    RegularSimpleFieldStorageInfo(SimpleField<T> field) {
        super(field);
        assert (field.parent == null);
    }

    @Override
    void unreferenceAll(Transaction tx, ObjId target, NavigableSet<ObjId> referrers) {
        assert (this.fieldType instanceof ReferenceFieldType);
        for (ObjId referrer : referrers) {
            tx.writeSimpleField(referrer, this.storageId, null, false);
        }
    }

    @Override
    void readAllNonNull(Transaction tx, ObjId target, Set<T> values, Predicate<? super T> filter) {
        Object value = tx.readSimpleField(target, this.storageId, false);
        if (value != null && (filter == null || filter.test(value))) {
            values.add(value);
        }
    }

    @Override
    public String toString() {
        return "simple field with " + this.fieldType;
    }
}

