/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.IndexStorageInfo;
import org.jsimpledb.core.IndexView;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.KVStore;

abstract class SimpleFieldStorageInfo<T>
extends IndexStorageInfo {
    final FieldType<T> fieldType;

    SimpleFieldStorageInfo(SimpleField<T> field) {
        super(field.storageId);
        this.fieldType = field.fieldType.genericizeForIndex();
    }

    CoreIndex<T, ObjId> getIndex(Transaction tx) {
        return new CoreIndex<T, ObjId>((KVStore)tx.kvt, new IndexView<T, ObjId>(this.storageId, this.fieldType, FieldTypeRegistry.OBJ_ID));
    }

    abstract void unreferenceAll(Transaction var1, ObjId var2, NavigableSet<ObjId> var3);

    abstract void readAllNonNull(Transaction var1, ObjId var2, Set<T> var3, Predicate<? super T> var4);

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SimpleFieldStorageInfo that = (SimpleFieldStorageInfo)obj;
        return this.fieldType.equals(that.fieldType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.fieldType.hashCode();
    }
}

