/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import org.jsimpledb.core.Database;
import org.jsimpledb.core.Layout;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.Schemas;
import org.jsimpledb.core.SnapshotKVTransaction;
import org.jsimpledb.core.StaleTransactionException;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;

public class SnapshotTransaction
extends Transaction {
    SnapshotTransaction(Database db, KVStore kvstore, Schemas schemas) {
        super(db, new SnapshotKVTransaction(kvstore), schemas);
    }

    SnapshotTransaction(Database db, KVStore kvstore, Schemas schemas, int versionNumber) {
        super(db, (KVTransaction)new SnapshotKVTransaction(kvstore), schemas, versionNumber);
    }

    SnapshotTransaction(Database db, KVStore kvstore, Schemas schemas, Schema schema) {
        super(db, (KVTransaction)new SnapshotKVTransaction(kvstore), schemas, schema);
    }

    @Override
    public boolean isSnapshot() {
        return true;
    }

    public KVStore getKVStore() {
        return ((SnapshotKVTransaction)this.kvt).delegate();
    }

    public synchronized void reset() {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Layout.deleteObjectData((KVStore)this.kvt);
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException("snapshot transaction");
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("snapshot transaction");
    }

    @Override
    public void addCallback(Transaction.Callback callback) {
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }
}

