/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.core.AbstractCoreIndex;
import org.jsimpledb.core.ComplexField;
import org.jsimpledb.core.CompositeIndex;
import org.jsimpledb.core.CompositeIndexStorageInfo;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.CoreIndex3;
import org.jsimpledb.core.CoreIndex4;
import org.jsimpledb.core.CounterField;
import org.jsimpledb.core.CreateListener;
import org.jsimpledb.core.Database;
import org.jsimpledb.core.DatabaseException;
import org.jsimpledb.core.DeleteAction;
import org.jsimpledb.core.DeleteListener;
import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldChangeNotifier;
import org.jsimpledb.core.FieldMonitor;
import org.jsimpledb.core.FieldSwitchAdapter;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.InconsistentDatabaseException;
import org.jsimpledb.core.IndexSet;
import org.jsimpledb.core.InvalidSchemaException;
import org.jsimpledb.core.Layout;
import org.jsimpledb.core.ListElementStorageInfo;
import org.jsimpledb.core.ListField;
import org.jsimpledb.core.ListFieldChangeListener;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.MapFieldChangeListener;
import org.jsimpledb.core.MapValueStorageInfo;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjInfo;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.ObjTypeSet;
import org.jsimpledb.core.ObjTypeStorageInfo;
import org.jsimpledb.core.ReferenceField;
import org.jsimpledb.core.ReferencedObjectException;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SchemaItem;
import org.jsimpledb.core.SchemaMismatchException;
import org.jsimpledb.core.Schemas;
import org.jsimpledb.core.SetField;
import org.jsimpledb.core.SetFieldChangeListener;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.SimpleFieldChangeListener;
import org.jsimpledb.core.SimpleFieldStorageInfo;
import org.jsimpledb.core.SnapshotTransaction;
import org.jsimpledb.core.StaleTransactionException;
import org.jsimpledb.core.TypeNotInSchemaVersionException;
import org.jsimpledb.core.UnknownFieldException;
import org.jsimpledb.core.UnknownIndexException;
import org.jsimpledb.core.UnknownTypeException;
import org.jsimpledb.core.VersionChangeListener;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.core.util.ObjIdMap;
import org.jsimpledb.core.util.ObjIdSet;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.util.NavigableMapKVStore;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.CloseableIterator;
import org.jsimpledb.util.NavigableSets;
import org.jsimpledb.util.UnsignedIntEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Transaction {
    private static final int MAX_GENERATED_KEY_ATTEMPTS = Integer.parseInt(System.getProperty(Transaction.class.getName() + ".MAX_GENERATED_KEY_ATTEMPTS", "64"));
    private static final int MAX_OBJ_INFO_CACHE_ENTRIES = Integer.parseInt(System.getProperty(Transaction.class.getName() + ".MAX_OBJ_INFO_CACHE_ENTRIES", "1000"));
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    final Database db;
    final KVTransaction kvt;
    final Schemas schemas;
    final Schema schema;
    @GuardedBy(value="this")
    boolean stale;
    @GuardedBy(value="this")
    boolean ending;
    @GuardedBy(value="this")
    boolean rollbackOnly;
    @GuardedBy(value="this")
    boolean disableListenerNotifications;
    @GuardedBy(value="this")
    private Set<VersionChangeListener> versionChangeListeners;
    @GuardedBy(value="this")
    private Set<CreateListener> createListeners;
    @GuardedBy(value="this")
    private Set<DeleteListener> deleteListeners;
    @GuardedBy(value="this")
    private NavigableMap<Integer, Set<FieldMonitor>> monitorMap;
    @GuardedBy(value="this")
    private NavigableSet<Long> hasFieldMonitorCache;
    @GuardedBy(value="this")
    private boolean listenerSetInstalled;
    @GuardedBy(value="this")
    private LinkedHashSet<Callback> callbacks;
    @GuardedBy(value="this")
    private final ThreadLocal<TreeMap<Integer, ArrayList<FieldChangeNotifier<?>>>> pendingNotifications = new ThreadLocal();
    @GuardedBy(value="this")
    private final ObjIdMap<ObjInfo> objInfoCache = new ObjIdMap();
    @GuardedBy(value="this")
    private Object userObject;
    private ObjIdMap<ReferenceField> deletedAssignments;
    private ObjIdMap<ObjId> copyIdMap;

    Transaction(Database db, KVTransaction kvt, Schemas schemas) {
        this(db, kvt, schemas, schemas.versions.lastKey());
    }

    Transaction(Database db, KVTransaction kvt, Schemas schemas, int versionNumber) {
        this(db, kvt, schemas, schemas.getVersion(versionNumber));
    }

    Transaction(Database db, KVTransaction kvt, Schemas schemas, Schema schema) {
        assert (db != null);
        assert (kvt != null);
        assert (schemas != null);
        assert (schema != null);
        assert (schema == schemas.getVersion(schema.versionNumber));
        this.db = db;
        this.kvt = kvt;
        this.schemas = schemas;
        this.schema = schema;
    }

    public Database getDatabase() {
        return this.db;
    }

    public Schemas getSchemas() {
        return this.schemas;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public synchronized boolean deleteSchemaVersion(int version) {
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (Object)"invalid non-positive schema version");
        Preconditions.checkArgument((version != this.schema.getVersionNumber() ? 1 : 0) != 0, (Object)"version is this transaction's version");
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        if (this.queryVersion().asMap().containsKey(version)) {
            throw new InvalidSchemaException("one or more version " + version + " objects still exist in database");
        }
        if (!this.schemas.deleteVersion(version)) {
            return false;
        }
        this.kvt.remove(Layout.getSchemaKey(version));
        return true;
    }

    public KVTransaction getKVTransaction() {
        return this.kvt;
    }

    /*
     * Exception decompiling
     */
    public synchronized void commit() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void rollback() {
        if (this.stale) {
            return;
        }
        if (this.ending) {
            this.log.warn("rollback() invoked re-entrantly from commit callback (ignoring)");
            return;
        }
        this.ending = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace("rollback() invoked on" + (this.isReadOnly() ? " read-only" : "") + " transaction " + this);
        }
        try {
            this.triggerBeforeCompletion();
        }
        finally {
            this.stale = true;
        }
        try {
            this.kvt.rollback();
        }
        finally {
            this.triggerAfterCompletion(false);
        }
    }

    private void triggerBeforeCompletion() {
        assert (Thread.holdsLock(this));
        if (this.callbacks == null) {
            return;
        }
        for (Callback callback : this.callbacks) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("invoking beforeCompletion() on transaction " + this + " callback " + callback);
            }
            try {
                callback.beforeCompletion();
            }
            catch (Throwable t) {
                this.log.error("error from beforeCompletion() method of transaction " + this + " callback " + callback + " (ignoring)", t);
            }
        }
    }

    private void triggerAfterCompletion(boolean committed) {
        assert (Thread.holdsLock(this));
        if (this.callbacks == null) {
            return;
        }
        for (Callback callback : this.callbacks) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("invoking afterCompletion() on transaction " + this + " callback " + callback);
            }
            try {
                callback.afterCompletion(committed);
            }
            catch (Throwable t) {
                this.log.error("error from afterCompletion() method of transaction " + this + " callback " + callback + " (ignoring)", t);
            }
        }
    }

    public synchronized boolean isValid() {
        return !this.stale;
    }

    public synchronized boolean isReadOnly() {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        return this.kvt.isReadOnly();
    }

    public synchronized void setReadOnly(boolean readOnly) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        this.kvt.setReadOnly(readOnly);
    }

    public synchronized boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public synchronized void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public synchronized void setTimeout(long timeout) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        this.kvt.setTimeout(timeout);
    }

    public synchronized void addCallback(Callback callback) {
        Preconditions.checkArgument((callback != null ? 1 : 0) != 0, (Object)"null callback");
        if (this.stale || this.ending) {
            throw new StaleTransactionException(this);
        }
        if (this.callbacks == null) {
            this.callbacks = new LinkedHashSet();
        }
        this.callbacks.add(callback);
    }

    public SnapshotTransaction createSnapshotTransaction() {
        NavigableMapKVStore kvstore = new NavigableMapKVStore();
        Layout.copyMetaData((KVStore)this.kvt, (KVStore)kvstore);
        return new SnapshotTransaction(this.db, (KVStore)kvstore, this.schemas, this.schema);
    }

    public boolean isSnapshot() {
        return false;
    }

    public boolean create(ObjId id) {
        return this.create(id, this.schema.versionNumber);
    }

    public synchronized boolean create(ObjId id, int versionNumber) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        if (this.exists(id)) {
            return false;
        }
        Schema objSchema = versionNumber == this.schema.versionNumber ? this.schema : this.schemas.getVersion(versionNumber);
        ObjType objType = objSchema.getObjType(id.getStorageId());
        this.createObjectData(id, versionNumber, objSchema, objType);
        return true;
    }

    public ObjId create(int storageId) {
        return this.create(storageId, this.schema.versionNumber);
    }

    public synchronized ObjId create(int storageId, int versionNumber) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Schema objSchema = versionNumber == this.schema.versionNumber ? this.schema : this.schemas.getVersion(versionNumber);
        ObjType objType = objSchema.getObjType(storageId);
        ObjId id = this.generateIdValidated(storageId);
        this.createObjectData(id, versionNumber, objSchema, objType);
        return id;
    }

    public synchronized ObjId generateId(int storageId) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        ObjTypeStorageInfo info = this.schemas.verifyStorageInfo(storageId, ObjTypeStorageInfo.class);
        return this.generateIdValidated(info.storageId);
    }

    private ObjId generateIdValidated(int storageId) {
        assert (Thread.holdsLock(this));
        ByteWriter keyWriter = new ByteWriter();
        for (int attempts = 0; attempts < MAX_GENERATED_KEY_ATTEMPTS; ++attempts) {
            ObjId id = new ObjId(storageId);
            id.writeTo(keyWriter);
            if (this.kvt.get(keyWriter.getBytes()) == null) {
                return id;
            }
            keyWriter.reset(0);
        }
        throw new DatabaseException("could not find a new, unused object ID after " + MAX_GENERATED_KEY_ATTEMPTS + " attempts; is our source of randomness truly random?");
    }

    private synchronized void createObjectData(ObjId id, int versionNumber, Schema schema, ObjType objType) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        assert (this.kvt.get(id.getBytes()) == null);
        assert (this.objInfoCache.get(id) == null);
        ObjInfo.write(this, id, versionNumber, false);
        if (this.objInfoCache.size() >= MAX_OBJ_INFO_CACHE_ENTRIES) {
            this.objInfoCache.removeOne();
        }
        this.objInfoCache.put(id, new ObjInfo(this, id, versionNumber, false, schema, objType));
        this.kvt.put(Layout.buildVersionIndexKey(id, objType.schema.versionNumber), ByteUtil.EMPTY);
        if (!objType.counterFields.isEmpty()) {
            for (CounterField field2 : objType.counterFields.values()) {
                this.kvt.put(field2.buildKey(id), this.kvt.encodeCounter(0L));
            }
        }
        objType.indexedSimpleFields.forEach((Consumer<SimpleField<?>>)((Consumer<SimpleField>)field -> this.kvt.put(Transaction.buildSimpleIndexEntry(field, id, null), ByteUtil.EMPTY)));
        for (CompositeIndex index : objType.compositeIndexes.values()) {
            this.kvt.put(Transaction.buildDefaultCompositeIndexEntry(id, index), ByteUtil.EMPTY);
        }
        if (!this.disableListenerNotifications && this.createListeners != null) {
            for (Iterator<SchemaItem> iterator : this.createListeners.toArray(new CreateListener[this.createListeners.size()])) {
                iterator.onCreate(this, id);
            }
        }
    }

    public synchronized boolean delete(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        if (!this.exists(id)) {
            return false;
        }
        ObjIdSet deletables = new ObjIdSet();
        deletables.add(id);
        boolean found = false;
        while (!deletables.isEmpty()) {
            found |= this.doDelete(deletables.iterator().next(), deletables);
        }
        return found;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private synchronized boolean doDelete(ObjId id, ObjIdSet deletables) {
        block3: while (true) {
            try {
                info = this.getObjectInfo(id, false);
            }
            catch (DeletedObjectException e) {
                deletables.remove(id);
                return false;
            }
            catch (UnknownTypeException e) {
                throw new InconsistentDatabaseException("encountered reference with unknown type during delete cascade: " + id, e);
            }
            for (Map.Entry entry : this.findReferrers(id, DeleteAction.EXCEPTION).entrySet()) {
                for (ObjId referrer : entry.getValue()) {
                    if (referrer.equals(id)) continue;
                    throw new ReferencedObjectException(this, id, referrer, entry.getKey());
                }
            }
            if (info.isDeleteNotified() || this.deleteListeners == null || this.deleteListeners.isEmpty()) break;
            ObjInfo.write(this, id, info.getVersion(), true);
            this.objInfoCache.put(id, new ObjInfo(this, id, info.getVersion(), true, info.schema, info.objType));
            if (this.disableListenerNotifications || this.deleteListeners == null) continue;
            var4_4 = this.deleteListeners.toArray(new DeleteListener[this.deleteListeners.size()]);
            entry = ((Iterator<Object>)var4_4).length;
            var6_10 = 0;
            while (true) {
                if (var6_10 < entry) ** break;
                continue block3;
                listener = var4_4[var6_10];
                listener.onDelete(this, id);
                ++var6_10;
            }
            break;
        }
        for (ReferenceField field : info.getObjType().referenceFieldsAndSubFields.values()) {
            if (!field.cascadeDelete) continue;
            refs = field.parent != null ? field.parent.iterateSubField(this, id, field) : Collections.singleton(field.getValue(this, id));
            for (ObjId ref : refs) {
                if (ref == null) continue;
                deletables.add(ref);
            }
        }
        this.deleteObjectData(info);
        deletables.remove(id);
        for (Map.Entry entry : this.findReferrers(id, DeleteAction.UNREFERENCE).entrySet()) {
            storageId = (Integer)entry.getKey();
            referrers = (NavigableSet)entry.getValue();
            fieldInfo = this.schemas.verifyStorageInfo(storageId, SimpleFieldStorageInfo.class);
            fieldInfo.unreferenceAll(this, id, referrers);
        }
        this.findReferrers(id, DeleteAction.DELETE).values().forEach((Consumer<NavigableSet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addAll(java.util.Collection<? extends E> ), (Ljava/util/NavigableSet;)V)((ObjIdSet)deletables));
        return true;
    }

    private void deleteObjectData(ObjInfo info) {
        assert (Thread.holdsLock(this));
        assert (this.kvt.get(info.getId().getBytes()) != null);
        ObjId id = info.getId();
        ObjType type = info.getObjType();
        type.indexedSimpleFields.forEach((Consumer<SimpleField<?>>)((Consumer<SimpleField>)field -> this.kvt.remove(Transaction.buildSimpleIndexEntry(field, id, this.kvt.get(field.buildKey(id))))));
        for (CompositeIndex compositeIndex : type.compositeIndexes.values()) {
            this.kvt.remove(this.buildCompositeIndexEntry(id, compositeIndex));
        }
        for (ComplexField complexField : type.complexFields.values()) {
            complexField.removeIndexEntries(this, id);
        }
        byte[] minKey = info.getId().getBytes();
        byte[] byArray = ByteUtil.getKeyAfterPrefix((byte[])minKey);
        this.kvt.removeRange(minKey, byArray);
        this.kvt.remove(Layout.buildVersionIndexKey(id, info.getVersion()));
        this.objInfoCache.remove(id);
    }

    public synchronized boolean exists(ObjId id) {
        return this.getObjectInfoIfExists(id, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean copy(ObjId source, Transaction dest, boolean updateVersion, boolean notifyListeners, ObjIdMap<ReferenceField> deletedAssignments, ObjIdMap<ObjId> objectIdMap) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"null source");
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        ObjInfo srcInfo = this.getObjectInfo(source, updateVersion);
        Transaction transaction = dest;
        synchronized (transaction) {
            if (dest.stale) {
                throw new StaleTransactionException(dest);
            }
            return dest.mutateAndNotify(() -> {
                ObjIdMap<ObjId> previousCopyIdMap = dest.copyIdMap;
                dest.copyIdMap = objectIdMap;
                ObjIdMap<ReferenceField> previousCopyDeletedAssignments = dest.deletedAssignments;
                dest.deletedAssignments = deletedAssignments;
                boolean previousDisableListenerNotifications = dest.disableListenerNotifications;
                dest.disableListenerNotifications = !notifyListeners;
                try {
                    Boolean bl = Transaction.doCopyFields(srcInfo, this, dest, updateVersion);
                    return bl;
                }
                finally {
                    dest.copyIdMap = previousCopyIdMap;
                    dest.deletedAssignments = previousCopyDeletedAssignments;
                    dest.disableListenerNotifications = previousDisableListenerNotifications;
                }
            });
        }
    }

    private static boolean doCopyFields(ObjInfo srcInfo, Transaction srcTx, Transaction dstTx, boolean updateVersion) {
        boolean existed;
        Schema dstSchema;
        ObjId dstId;
        assert (Thread.holdsLock(srcTx));
        assert (Thread.holdsLock(dstTx));
        ObjId srcId = srcInfo.getId();
        ObjId objId = dstId = dstTx.copyIdMap != null && dstTx.copyIdMap.containsKey(srcId) ? dstTx.copyIdMap.get(srcId) : srcId;
        if (dstId == null) {
            throw new IllegalArgumentException("can't copy " + srcId + " because " + srcId + " is remapped to null");
        }
        int typeStorageId = srcId.getStorageId();
        if (dstId.getStorageId() != typeStorageId) {
            throw new IllegalArgumentException("can't copy " + srcId + " to " + dstId + " due to non-equal storage ID's (" + typeStorageId + " != " + dstId.getStorageId() + ")");
        }
        if (updateVersion && srcInfo.getVersion() != srcTx.schema.versionNumber) {
            srcTx.changeVersion(srcInfo, srcTx.schema);
            srcInfo = srcTx.loadIntoCache(srcId);
        }
        Schema srcSchema = srcInfo.getSchema();
        int objectVersion = srcSchema.versionNumber;
        try {
            dstSchema = dstTx.schemas.getVersion(objectVersion);
        }
        catch (IllegalArgumentException e) {
            throw new SchemaMismatchException("destination transaction has no schema version " + objectVersion);
        }
        if (!Arrays.equals(srcSchema.encodedXML, dstSchema.encodedXML) && !srcSchema.schemaModel.isCompatibleWith(dstSchema.schemaModel)) {
            throw new SchemaMismatchException("destination transaction schema version " + objectVersion + " does not match source schema version " + objectVersion + "\n" + dstSchema.schemaModel.differencesFrom(srcSchema.schemaModel));
        }
        ObjInfo dstInfo = dstTx.getObjectInfoIfExists(dstId, false);
        boolean bl = existed = dstInfo != null;
        if (existed && dstInfo.getVersion() != objectVersion && dstTx.versionChangeListeners != null && !dstTx.versionChangeListeners.isEmpty()) {
            dstTx.changeVersion(dstInfo, dstSchema);
            dstInfo = dstTx.loadIntoCache(dstId);
        }
        ObjType srcType = srcSchema.getObjType(typeStorageId);
        ObjType dstType = dstSchema.getObjType(typeStorageId);
        if (dstTx.copyIdMap != null || !dstTx.disableListenerNotifications && dstTx.hasFieldMonitor(dstType)) {
            if (!existed) {
                dstTx.createObjectData(dstId, objectVersion, dstSchema, dstType);
            }
            for (Field<?> field2 : srcType.fields.values()) {
                field2.copy(srcId, dstId, srcTx, dstTx, dstTx.copyIdMap);
            }
        } else {
            assert (srcType.schema.versionNumber == dstType.schema.versionNumber);
            for (ReferenceField field3 : dstType.referenceFieldsAndSubFields.values()) {
                field3.findAnyDeletedAssignments(srcTx, dstTx, dstId);
            }
            if (srcId.equals(dstId) && srcTx.equals(dstTx)) {
                return !existed;
            }
            if (dstInfo != null) {
                dstTx.deleteObjectData(dstInfo);
            }
            dstTx.kvt.put(Layout.buildVersionIndexKey(dstId, objectVersion), ByteUtil.EMPTY);
            KeyRange srcKeyRange = KeyRange.forPrefix((byte[])srcId.getBytes());
            ByteWriter dstWriter = new ByteWriter();
            dstWriter.write(dstId.getBytes());
            int dstMark = dstWriter.mark();
            Throwable throwable = null;
            try (CloseableIterator i = srcTx.kvt.getRange(srcKeyRange);){
                while (i.hasNext()) {
                    KVPair kv = (KVPair)i.next();
                    assert (srcKeyRange.contains(kv.getKey()));
                    ByteReader srcReader = new ByteReader(kv.getKey());
                    srcReader.skip(8);
                    dstWriter.reset(dstMark);
                    dstWriter.write(srcReader);
                    dstTx.kvt.put(dstWriter.getBytes(), kv.getValue());
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            dstType.indexedSimpleFields.forEach((Consumer<SimpleField<?>>)((Consumer<SimpleField>)field -> {
                byte[] fieldValue = dstTx.kvt.get(field.buildKey(dstId));
                byte[] indexKey = Transaction.buildSimpleIndexEntry(field, dstId, fieldValue);
                dstTx.kvt.put(indexKey, ByteUtil.EMPTY);
            }));
            for (CompositeIndex compositeIndex : dstType.compositeIndexes.values()) {
                dstTx.kvt.put(Transaction.buildCompositeIndexEntry(dstTx, dstId, compositeIndex), ByteUtil.EMPTY);
            }
            for (ComplexField complexField : dstType.complexFields.values()) {
                complexField.getSubFields().stream().filter(subField -> subField.indexed).forEach(subField -> field4.addIndexEntries(dstTx, dstId, (SimpleField<?>)subField));
            }
        }
        return !existed;
    }

    public synchronized void addCreateListener(CreateListener listener) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        if (this.listenerSetInstalled) {
            throw new UnsupportedOperationException("ListenerSet installed");
        }
        if (this.createListeners == null) {
            this.createListeners = new HashSet<CreateListener>(1);
        }
        this.createListeners.add(listener);
    }

    public synchronized void removeCreateListener(CreateListener listener) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        if (this.listenerSetInstalled) {
            throw new UnsupportedOperationException("ListenerSet installed");
        }
        if (this.createListeners == null) {
            return;
        }
        this.createListeners.remove(listener);
    }

    public synchronized void addDeleteListener(DeleteListener listener) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        if (this.listenerSetInstalled) {
            throw new UnsupportedOperationException("ListenerSet installed");
        }
        if (this.deleteListeners == null) {
            this.deleteListeners = new HashSet<DeleteListener>(1);
        }
        this.deleteListeners.add(listener);
    }

    public synchronized void removeDeleteListener(DeleteListener listener) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        if (this.listenerSetInstalled) {
            throw new UnsupportedOperationException("ListenerSet installed");
        }
        if (this.deleteListeners == null) {
            return;
        }
        this.deleteListeners.remove(listener);
    }

    public synchronized int getSchemaVersion(ObjId id) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        return this.getObjectInfo(id, false).getVersion();
    }

    public synchronized boolean updateSchemaVersion(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        final ObjInfo info = this.getObjectInfo(id, false);
        if (info.getVersion() == this.schema.versionNumber) {
            return false;
        }
        this.mutateAndNotify(new Mutation<Void>(){

            @Override
            public Void mutate() {
                Transaction.this.changeVersion(info, Transaction.this.schema);
                return null;
            }
        });
        return true;
    }

    private void changeVersion(ObjInfo info, Schema targetVersion) {
        NavigableMap navigableMap;
        Field<?> newField;
        Field oldField;
        ObjType newType;
        final ObjId id = info.getId();
        int oldVersion = info.getVersion();
        int newVersion = targetVersion.versionNumber;
        assert (Thread.holdsLock(this));
        assert (this.schemas.getVersion(targetVersion.versionNumber) == targetVersion);
        Preconditions.checkArgument((newVersion != oldVersion ? 1 : 0) != 0, (Object)"object already at version");
        ObjType oldType = info.getObjType();
        try {
            newType = targetVersion.getObjType(id.getStorageId());
        }
        catch (UnknownTypeException e) {
            throw (TypeNotInSchemaVersionException)new TypeNotInSchemaVersionException(id, newVersion).initCause(e);
        }
        final TreeMap oldValueMap = this.versionChangeListeners != null && !this.versionChangeListeners.isEmpty() ? new TreeMap() : null;
        oldType.compositeIndexes.values().stream().filter(index -> !newType.compositeIndexes.containsKey(index.storageId)).forEach(index -> this.kvt.remove(this.buildCompositeIndexEntry(id, (CompositeIndex)index)));
        HashMap compatibleFieldMap = new HashMap(oldType.fields.size());
        for (Map.Entry<Integer, Field<?>> entry : oldType.fields.entrySet()) {
            Integer n = entry.getKey();
            oldField = entry.getValue();
            newField = newType.fields.get(n);
            boolean compatible = newField != null && newField.isUpgradeCompatible(oldField);
            compatibleFieldMap.put(oldField, compatible ? newField : null);
        }
        final ArrayList incompatibleNewFields = new ArrayList(newType.fields.size());
        for (Map.Entry<Integer, Field<?>> entry : newType.fields.entrySet()) {
            Integer storageId = entry.getKey();
            newField = entry.getValue();
            Field<?> oldField2 = oldType.fields.get(storageId);
            if (oldField2 == null || compatibleFieldMap.get(oldField2) == null) {
                incompatibleNewFields.add(newField);
                continue;
            }
            assert (compatibleFieldMap.get(oldField2) == newField);
        }
        for (final Map.Entry entry : compatibleFieldMap.entrySet()) {
            oldField = (Field)entry.getKey();
            if (oldValueMap != null) {
                oldField.visit(new FieldSwitchAdapter<Void>(){

                    @Override
                    public <T> Void caseSimpleField(SimpleField<T> oldField) {
                        byte[] key = Field.buildKey(id, oldField.storageId);
                        byte[] oldValue = Transaction.this.kvt.get(key);
                        oldValueMap.put(oldField.storageId, oldValue != null ? oldField.fieldType.read(new ByteReader(oldValue)) : oldField.fieldType.getDefaultValueObject());
                        return null;
                    }

                    @Override
                    public <T> Void caseComplexField(ComplexField<T> oldField) {
                        oldValueMap.put(oldField.storageId, oldField.getValueReadOnlyCopy(Transaction.this, id));
                        return null;
                    }

                    @Override
                    public Void caseCounterField(CounterField oldField) {
                        byte[] key = Field.buildKey(id, oldField.storageId);
                        byte[] oldValue = Transaction.this.kvt.get(key);
                        oldValueMap.put(oldField.storageId, oldValue != null ? Transaction.this.kvt.decodeCounter(oldValue) : 0L);
                        return null;
                    }
                });
            }
            oldField.visit(new FieldSwitchAdapter<Void>(){

                @Override
                public Void caseReferenceField(ReferenceField oldField) {
                    ObjId ref;
                    SortedSet xtypes;
                    ReferenceField newField = (ReferenceField)entry.getValue();
                    if (newField != null && !(xtypes = Transaction.this.findRemovedTypes(oldField, newField)).isEmpty() && (ref = (ObjId)oldField.getValue(Transaction.this, id)) != null && xtypes.contains(ref.getStorageId())) {
                        entry.setValue(null);
                        incompatibleNewFields.add(newField);
                    }
                    return this.caseSimpleField((SimpleField)oldField);
                }

                @Override
                public <T> Void caseSimpleField(SimpleField<T> oldField) {
                    byte[] value;
                    SimpleField newField = (SimpleField)entry.getValue();
                    boolean reset = newField == null;
                    byte[] key = Field.buildKey(id, oldField.storageId);
                    if (oldField.indexed && (reset || !newField.indexed)) {
                        value = Transaction.this.kvt.get(key);
                        Transaction.this.kvt.remove(Transaction.buildSimpleIndexEntry(oldField, id, value));
                    }
                    if (newField != null && newField.indexed && (reset || !oldField.indexed)) {
                        value = !reset ? Transaction.this.kvt.get(key) : null;
                        Transaction.this.kvt.put(Transaction.buildSimpleIndexEntry(newField, id, value), ByteUtil.EMPTY);
                    }
                    if (reset) {
                        Transaction.this.kvt.remove(key);
                    }
                    return null;
                }

                @Override
                public <E> Void caseComplexField(ComplexField<E> oldField) {
                    ComplexField newField = (ComplexField)entry.getValue();
                    boolean reset = newField == null;
                    List<SimpleField<?>> oldSubFields = oldField.getSubFields();
                    List<SimpleField<?>> newSubFields = !reset ? newField.getSubFields() : null;
                    for (int i = 0; i < oldSubFields.size(); ++i) {
                        ReferenceField newRefField;
                        ReferenceField oldRefField;
                        SortedSet xtypes;
                        SimpleField<?> newSubField;
                        SimpleField<?> oldSubField = oldSubFields.get(i);
                        SimpleField<?> simpleField = newSubField = !reset ? newSubFields.get(i) : null;
                        if (!reset && oldSubField instanceof ReferenceField && !(xtypes = Transaction.this.findRemovedTypes(oldRefField = (ReferenceField)oldSubField, newRefField = (ReferenceField)newSubField)).isEmpty()) {
                            oldField.unreferenceRemovedTypes(Transaction.this, id, oldRefField, xtypes);
                        }
                        if (oldSubField.indexed && (reset || !newSubField.indexed)) {
                            oldField.removeIndexEntries(Transaction.this, id, oldSubField);
                        }
                        if (oldSubField.indexed || reset || !newSubField.indexed) continue;
                        newField.addIndexEntries(Transaction.this, id, newSubField);
                    }
                    if (reset) {
                        oldField.deleteContent(Transaction.this, id);
                    }
                    return null;
                }

                @Override
                public Void caseCounterField(CounterField oldField) {
                    boolean reset;
                    boolean bl = reset = entry.getValue() == null;
                    if (reset) {
                        Transaction.this.kvt.remove(Field.buildKey(id, oldField.storageId));
                    }
                    return null;
                }
            });
        }
        for (Field field : incompatibleNewFields) {
            field.visit(new FieldSwitchAdapter<Void>(){

                @Override
                public <T> Void caseSimpleField(SimpleField<T> newField) {
                    if (newField.indexed) {
                        Transaction.this.kvt.put(Transaction.buildSimpleIndexEntry(newField, id, null), ByteUtil.EMPTY);
                    }
                    return null;
                }

                @Override
                public <E> Void caseComplexField(ComplexField<E> newField) {
                    return null;
                }

                @Override
                public Void caseCounterField(CounterField newField) {
                    byte[] key = Field.buildKey(id, newField.storageId);
                    Transaction.this.kvt.put(key, Transaction.this.kvt.encodeCounter(0L));
                    return null;
                }
            });
        }
        newType.compositeIndexes.values().stream().filter(index -> !oldType.compositeIndexes.containsKey(index.storageId)).forEach(index -> this.kvt.put(this.buildCompositeIndexEntry(id, (CompositeIndex)index), ByteUtil.EMPTY));
        ObjInfo.write(this, id, newVersion, info.isDeleteNotified());
        this.objInfoCache.put(id, new ObjInfo(this, id, newVersion, info.isDeleteNotified(), targetVersion, newType));
        this.kvt.remove(Layout.buildVersionIndexKey(id, oldVersion));
        this.kvt.put(Layout.buildVersionIndexKey(id, newVersion), ByteUtil.EMPTY);
        NavigableMap navigableMap2 = navigableMap = oldValueMap != null ? Maps.unmodifiableNavigableMap(oldValueMap) : null;
        if (this.versionChangeListeners != null) {
            for (VersionChangeListener listener : this.versionChangeListeners) {
                listener.onVersionChange(this, id, oldVersion, newVersion, navigableMap);
            }
        }
    }

    private SortedSet<Integer> findRemovedTypes(ReferenceField oldField, ReferenceField newField) {
        SortedSet<Integer> newObjectTypes = newField.getObjectTypes();
        if (newObjectTypes == null) {
            return Collections.emptySortedSet();
        }
        SortedSet<Integer> oldObjectTypes = oldField.getObjectTypes();
        if (oldObjectTypes == null) {
            oldObjectTypes = this.schemas.objTypeStorageIds;
        }
        TreeSet<Integer> removedObjectTypes = new TreeSet<Integer>(oldObjectTypes);
        removedObjectTypes.removeAll(newObjectTypes);
        return removedObjectTypes;
    }

    public synchronized CoreIndex<Integer, ObjId> queryVersion() {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        return Layout.getVersionIndex((KVStore)this.kvt);
    }

    public synchronized void addVersionChangeListener(VersionChangeListener listener) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        if (this.listenerSetInstalled) {
            throw new UnsupportedOperationException("ListenerSet installed");
        }
        if (this.versionChangeListeners == null) {
            this.versionChangeListeners = new HashSet<VersionChangeListener>(1);
        }
        this.versionChangeListeners.add(listener);
    }

    public synchronized void removeVersionChangeListener(VersionChangeListener listener) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        if (this.listenerSetInstalled) {
            throw new UnsupportedOperationException("ListenerSet installed");
        }
        if (this.versionChangeListeners == null) {
            return;
        }
        this.versionChangeListeners.remove(listener);
    }

    public synchronized NavigableSet<ObjId> getAll() {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        return new ObjTypeSet(this);
    }

    public synchronized NavigableSet<ObjId> getAll(int storageId) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        this.schemas.verifyStorageInfo(storageId, ObjTypeStorageInfo.class);
        return new ObjTypeSet(this, storageId);
    }

    public synchronized Object readSimpleField(ObjId id, int storageId, boolean updateVersion) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        ObjInfo info = this.getObjectInfo(id, updateVersion);
        SimpleField<?> field = info.getObjType().simpleFields.get(storageId);
        if (field == null) {
            throw new UnknownFieldException(info.getObjType(), storageId, "simple field");
        }
        byte[] key = field.buildKey(id);
        byte[] value = this.kvt.get(key);
        return value != null ? field.fieldType.read(new ByteReader(value)) : field.fieldType.getDefaultValueObject();
    }

    public void writeSimpleField(final ObjId id, final int storageId, final Object value, final boolean updateVersion) {
        this.mutateAndNotify(id, new Mutation<Void>(){

            @Override
            public Void mutate() {
                Transaction.this.doWriteSimpleField(id, storageId, value, updateVersion);
                return null;
            }
        });
    }

    private synchronized void doWriteSimpleField(ObjId id, int storageId, final Object newObj, boolean updateVersion) {
        ObjInfo info = this.getObjectInfo(id, updateVersion);
        final SimpleField<?> field = info.getObjType().simpleFields.get(storageId);
        if (field == null) {
            throw new UnknownFieldException(info.getObjType(), storageId, "simple field");
        }
        if (field instanceof ReferenceField) {
            this.checkDeletedAssignment(id, (ReferenceField)field, (ObjId)newObj);
        }
        byte[] key = field.buildKey(id);
        byte[] newValue = field.encode(newObj);
        byte[] oldValue = null;
        if ((field.indexed || field.compositeIndexMap != null || !this.disableListenerNotifications && this.hasFieldMonitor(id, field.storageId)) && ((oldValue = this.kvt.get(key)) != null ? newValue != null && Arrays.equals(oldValue, newValue) : newValue == null)) {
            return;
        }
        if (newValue != null) {
            this.kvt.put(key, newValue);
        } else {
            this.kvt.remove(key);
        }
        if (field.indexed) {
            this.kvt.remove(Transaction.buildSimpleIndexEntry(field, id, oldValue));
            this.kvt.put(Transaction.buildSimpleIndexEntry(field, id, newValue), ByteUtil.EMPTY);
        }
        if (field.compositeIndexMap != null) {
            for (Map.Entry<CompositeIndex, Integer> entry : field.compositeIndexMap.entrySet()) {
                CompositeIndex index = entry.getKey();
                int fieldIndexOffset = entry.getValue();
                ByteWriter oldWriter = new ByteWriter();
                UnsignedIntEncoder.write((ByteWriter)oldWriter, (int)index.storageId);
                int fieldStart = -1;
                int fieldEnd = -1;
                for (SimpleField<?> otherField : index.fields) {
                    byte[] otherValue;
                    if (otherField == field) {
                        fieldStart = oldWriter.getLength();
                        otherValue = oldValue;
                    } else {
                        otherValue = this.kvt.get(otherField.buildKey(id));
                    }
                    oldWriter.write(otherValue != null ? otherValue : otherField.fieldType.getDefaultValue());
                    if (otherField != field) continue;
                    fieldEnd = oldWriter.getLength();
                }
                assert (fieldStart != -1);
                assert (fieldEnd != -1);
                id.writeTo(oldWriter);
                byte[] oldIndexEntry = oldWriter.getBytes();
                this.kvt.remove(oldIndexEntry);
                ByteWriter newWriter = new ByteWriter(oldIndexEntry.length);
                newWriter.write(oldIndexEntry, 0, fieldStart);
                newWriter.write(newValue != null ? newValue : field.fieldType.getDefaultValue());
                newWriter.write(oldIndexEntry, fieldEnd, oldIndexEntry.length - fieldEnd);
                this.kvt.put(newWriter.getBytes(), ByteUtil.EMPTY);
            }
        }
        if (!this.disableListenerNotifications) {
            final Object oldObj = oldValue != null ? field.fieldType.read(new ByteReader(oldValue)) : field.fieldType.getDefaultValueObject();
            this.addFieldChangeNotification(new SimpleFieldChangeNotifier(field, id){

                @Override
                public void notify(Transaction tx, SimpleFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                    listener.onSimpleFieldChange(tx, this.id, field, path, referrers, oldObj, newObj);
                }
            });
        }
    }

    void checkDeletedAssignment(ObjId id, ReferenceField field, ObjId targetId) {
        if (targetId == null) {
            return;
        }
        if (targetId.equals(id)) {
            return;
        }
        if (this instanceof SnapshotTransaction ? field.allowDeletedSnapshot : field.allowDeleted) {
            return;
        }
        if (this.exists(targetId)) {
            return;
        }
        if (this.deletedAssignments != null) {
            this.deletedAssignments.put(targetId, field);
            return;
        }
        throw new DeletedObjectException(targetId, "illegal assignment to " + field + " in " + this.getObjDescription(id) + " of reference to deleted object " + this.getObjDescription(targetId));
    }

    private static byte[] buildSimpleIndexEntry(SimpleField<?> field, ObjId id, byte[] value) {
        if (value == null) {
            value = field.fieldType.getDefaultValue();
        }
        ByteWriter writer = new ByteWriter(UnsignedIntEncoder.encodeLength((int)field.storageId) + value.length + 8);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)field.storageId);
        writer.write(value);
        id.writeTo(writer);
        return writer.getBytes();
    }

    public String getTypeDescription(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        int storageId = id.getStorageId();
        ObjType type = this.schema.objTypeMap.get(id.getStorageId());
        return type != null ? "type `" + type.getName() + "'" : "type #" + storageId;
    }

    String getObjDescription(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        return "object " + id + " (" + this.getTypeDescription(id) + ")";
    }

    String getFieldDescription(ObjId id, int storageId) {
        Field<?> field;
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        ObjType type = this.schema.objTypeMap.get(id.getStorageId());
        if (type == null) {
            return "field #" + storageId;
        }
        try {
            field = type.getField(storageId, true);
        }
        catch (UnknownFieldException e) {
            return "field #" + storageId;
        }
        return "field `" + field.getName() + "'";
    }

    public synchronized long readCounterField(ObjId id, int storageId, boolean updateVersion) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        ObjInfo info = this.getObjectInfo(id, updateVersion);
        CounterField field = info.getObjType().counterFields.get(storageId);
        if (field == null) {
            throw new UnknownFieldException(info.getObjType(), storageId, "counter field");
        }
        byte[] key = field.buildKey(id);
        byte[] value = this.kvt.get(key);
        return value != null ? this.kvt.decodeCounter(value) : 0L;
    }

    public synchronized void writeCounterField(ObjId id, int storageId, long value, boolean updateVersion) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        ObjInfo info = this.getObjectInfo(id, updateVersion);
        CounterField field = info.getObjType().counterFields.get(storageId);
        if (field == null) {
            throw new UnknownFieldException(info.getObjType(), storageId, "counter field");
        }
        byte[] key = field.buildKey(id);
        this.kvt.put(key, this.kvt.encodeCounter(value));
    }

    public synchronized void adjustCounterField(ObjId id, int storageId, long offset, boolean updateVersion) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        if (offset == 0L) {
            return;
        }
        ObjInfo info = this.getObjectInfo(id, updateVersion);
        CounterField field = info.getObjType().counterFields.get(storageId);
        if (field == null) {
            throw new UnknownFieldException(info.getObjType(), storageId, "counter field");
        }
        this.kvt.adjustCounter(field.buildKey(id), offset);
    }

    public NavigableSet<?> readSetField(ObjId id, int storageId, boolean updateVersion) {
        return this.readComplexField(id, storageId, updateVersion, SetField.class, NavigableSet.class);
    }

    public List<?> readListField(ObjId id, int storageId, boolean updateVersion) {
        return this.readComplexField(id, storageId, updateVersion, ListField.class, List.class);
    }

    public NavigableMap<?, ?> readMapField(ObjId id, int storageId, boolean updateVersion) {
        return this.readComplexField(id, storageId, updateVersion, MapField.class, NavigableMap.class);
    }

    public byte[] getKey(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        return id.getBytes();
    }

    public byte[] getKey(ObjId id, int storageId) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        Preconditions.checkArgument((storageId > 0 ? 1 : 0) != 0, (Object)"non-positive storageId");
        ByteWriter writer = new ByteWriter();
        id.writeTo(writer);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)storageId);
        return writer.getBytes();
    }

    synchronized boolean hasDefaultValue(ObjId id, SimpleField<?> field) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        if (!this.exists(id)) {
            throw new DeletedObjectException(this, id);
        }
        return this.kvt.get(field.buildKey(id)) == null;
    }

    private synchronized <F, V> V readComplexField(ObjId id, int storageId, boolean updateVersion, Class<F> fieldClass, Class<V> valueType) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        ObjInfo info = this.getObjectInfo(id, updateVersion);
        ComplexField<?> field = info.getObjType().complexFields.get(storageId);
        if (!fieldClass.isInstance(field)) {
            throw new UnknownFieldException(info.getObjType(), storageId, fieldClass.getSimpleName());
        }
        return valueType.cast(field.getValueInternal(this, id));
    }

    private ObjInfo getObjectInfoIfExists(ObjId id, boolean update) {
        assert (Thread.holdsLock(this));
        try {
            return this.getObjectInfo(id, update);
        }
        catch (DeletedObjectException | UnknownTypeException e) {
            return null;
        }
    }

    private ObjInfo getObjectInfo(ObjId id, boolean update) {
        assert (Thread.holdsLock(this));
        ObjInfo info = this.objInfoCache.get(id);
        if (info == null) {
            this.schemas.verifyStorageInfo(id.getStorageId(), ObjTypeStorageInfo.class);
            info = this.loadIntoCache(id);
        }
        if (!update || info.getVersion() == this.schema.versionNumber) {
            return info;
        }
        final ObjInfo info2 = info;
        this.mutateAndNotify(new Mutation<Void>(){

            @Override
            public Void mutate() {
                Transaction.this.changeVersion(info2, Transaction.this.schema);
                return null;
            }
        });
        return this.loadIntoCache(id);
    }

    private ObjInfo loadIntoCache(ObjId id) {
        ObjInfo info = this.objInfoCache.get(id);
        if (info == null) {
            info = new ObjInfo(this, id);
            if (this.objInfoCache.size() >= MAX_OBJ_INFO_CACHE_ENTRIES) {
                this.objInfoCache.removeOne();
            }
            this.objInfoCache.put(id, info);
        }
        return info;
    }

    public void addSimpleFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, SimpleFieldChangeListener listener) {
        this.addFieldChangeListener(storageId, path, filters, listener);
    }

    public void addSetFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, SetFieldChangeListener listener) {
        this.addFieldChangeListener(storageId, path, filters, listener);
    }

    public void addListFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, ListFieldChangeListener listener) {
        this.addFieldChangeListener(storageId, path, filters, listener);
    }

    public void addMapFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, MapFieldChangeListener listener) {
        this.addFieldChangeListener(storageId, path, filters, listener);
    }

    public synchronized void addFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, Object listener) {
        this.validateChangeListener(path, listener);
        this.getMonitorsForField(storageId, true).add(new FieldMonitor(storageId, path, filters, listener));
    }

    public void removeSimpleFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, SimpleFieldChangeListener listener) {
        this.removeFieldChangeListener(storageId, path, filters, listener);
    }

    public void removeSetFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, SetFieldChangeListener listener) {
        this.removeFieldChangeListener(storageId, path, filters, listener);
    }

    public void removeListFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, ListFieldChangeListener listener) {
        this.removeFieldChangeListener(storageId, path, filters, listener);
    }

    public void removeMapFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, MapFieldChangeListener listener) {
        this.removeFieldChangeListener(storageId, path, filters, listener);
    }

    public synchronized void removeFieldChangeListener(int storageId, int[] path, KeyRanges[] filters, Object listener) {
        this.validateChangeListener(path, listener);
        Set<FieldMonitor> monitors = this.getMonitorsForField(storageId);
        if (monitors != null) {
            monitors.remove(new FieldMonitor(storageId, path, filters, listener));
        }
    }

    private void validateChangeListener(int[] path, Object listener) {
        assert (Thread.holdsLock(this));
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"null path");
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        if (this.listenerSetInstalled) {
            throw new UnsupportedOperationException("ListenerSet installed");
        }
        this.verifyReferencePath(path);
    }

    private Set<FieldMonitor> getMonitorsForField(int storageId) {
        return this.getMonitorsForField(storageId, false);
    }

    private synchronized Set<FieldMonitor> getMonitorsForField(int storageId, boolean create) {
        HashSet monitors;
        if (this.monitorMap == null) {
            if (!create) {
                return null;
            }
            this.monitorMap = new TreeMap<Integer, Set<FieldMonitor>>();
            monitors = null;
        } else {
            monitors = (HashSet)this.monitorMap.get(storageId);
        }
        if (monitors == null) {
            if (!create) {
                return null;
            }
            monitors = new HashSet(1);
            this.monitorMap.put(storageId, monitors);
        }
        return monitors;
    }

    void addFieldChangeNotification(FieldChangeNotifier<?> notifier) {
        int fieldStorageId;
        assert (Thread.holdsLock(this));
        assert (!this.disableListenerNotifications);
        ObjId id = notifier.getId();
        if (!this.hasFieldMonitor(id, fieldStorageId = notifier.getStorageId())) {
            return;
        }
        this.pendingNotifications.get().computeIfAbsent(fieldStorageId, i -> new ArrayList(2)).add(notifier);
    }

    boolean hasFieldMonitor(ObjId id, int fieldStorageId) {
        assert (Thread.holdsLock(this));
        if (this.monitorMap == null) {
            return false;
        }
        int objTypeStorageId = id.getStorageId();
        if (this.hasFieldMonitorCache != null) {
            return this.hasFieldMonitorCache.contains(this.buildHasFieldMonitorCacheKey(objTypeStorageId, fieldStorageId));
        }
        Set<FieldMonitor> monitorsForField = this.getMonitorsForField(fieldStorageId);
        if (monitorsForField == null) {
            return false;
        }
        return monitorsForField.stream().anyMatch(new MonitoredPredicate(objTypeStorageId, fieldStorageId));
    }

    boolean hasFieldMonitor(ObjType objType) {
        assert (Thread.holdsLock(this));
        if (this.monitorMap == null) {
            return false;
        }
        int objTypeStorageId = objType.storageId;
        if (this.hasFieldMonitorCache != null) {
            long minKey = this.buildHasFieldMonitorCacheKey(objTypeStorageId, 0);
            if (objTypeStorageId == Integer.MAX_VALUE) {
                return this.hasFieldMonitorCache.ceiling(minKey) != null;
            }
            long maxKey = this.buildHasFieldMonitorCacheKey(objTypeStorageId + 1, 0);
            return !this.hasFieldMonitorCache.subSet(minKey, maxKey).isEmpty();
        }
        Iterator iterator = NavigableSets.intersection((NavigableSet[])new NavigableSet[]{objType.fields.navigableKeySet(), this.monitorMap.navigableKeySet()}).iterator();
        while (iterator.hasNext()) {
            int fieldStorageId = (Integer)iterator.next();
            if (!((Set)this.monitorMap.get(fieldStorageId)).stream().anyMatch(new MonitoredPredicate(objTypeStorageId, fieldStorageId))) continue;
            return true;
        }
        return false;
    }

    private long buildHasFieldMonitorCacheKey(int objTypeStorageId, int fieldStorageId) {
        return (long)objTypeStorageId << 32 | (long)fieldStorageId & 0xFFFFFFFFL;
    }

    private synchronized NavigableSet<Long> buildHasFieldMonitorCache() {
        if (this.monitorMap == null) {
            return Collections.emptyNavigableSet();
        }
        TreeSet<Long> set = new TreeSet<Long>();
        for (Schema otherSchema : this.schemas.versions.values()) {
            for (ObjType objType : otherSchema.objTypeMap.values()) {
                int objTypeStorageId = objType.storageId;
                for (Field<?> field : objType.fieldsAndSubFields) {
                    int fieldStorageId = field.storageId;
                    Set<FieldMonitor> monitors = this.getMonitorsForField(fieldStorageId);
                    if (monitors == null || !monitors.stream().anyMatch(new MonitoredPredicate(objTypeStorageId, fieldStorageId))) continue;
                    set.add(this.buildHasFieldMonitorCacheKey(objTypeStorageId, fieldStorageId));
                }
            }
        }
        return set;
    }

    synchronized <V> V mutateAndNotify(ObjId id, Mutation<V> mutation) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        if (!this.exists(id)) {
            throw new DeletedObjectException(this, id);
        }
        return this.mutateAndNotify(mutation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <V> V mutateAndNotify(Mutation<V> mutation) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        if (this.pendingNotifications.get() != null) {
            return mutation.mutate();
        }
        this.pendingNotifications.set(new TreeMap());
        try {
            V v = mutation.mutate();
            return v;
        }
        finally {
            try {
                TreeMap<Integer, ArrayList<FieldChangeNotifier<?>>> pendingNotificationMap = this.pendingNotifications.get();
                while (!pendingNotificationMap.isEmpty()) {
                    Map.Entry<Integer, ArrayList<FieldChangeNotifier<?>>> entry = pendingNotificationMap.pollFirstEntry();
                    int storageId = entry.getKey();
                    for (FieldChangeNotifier<?> notifier : entry.getValue()) {
                        assert (notifier.getStorageId() == storageId);
                        Set<FieldMonitor> monitors = this.getMonitorsForField(storageId);
                        if (monitors == null || monitors.isEmpty()) continue;
                        this.notifyFieldMonitors(notifier, NavigableSets.singleton((Object)notifier.getId()), new ArrayList<FieldMonitor>(monitors), 0);
                    }
                }
            }
            finally {
                this.pendingNotifications.remove();
            }
        }
    }

    private void notifyFieldMonitors(FieldChangeNotifier<?> notifier, NavigableSet<ObjId> objects, ArrayList<FieldMonitor> monitorList, int step) {
        HashMap<Integer, ArrayList> remainingMonitorsMap = new HashMap<Integer, ArrayList>();
        for (FieldMonitor fieldMonitor : monitorList) {
            KeyRanges filter;
            if (step == 0 && (filter = fieldMonitor.getTargetFilter()) != null && !filter.contains(notifier.getId().getBytes())) continue;
            if (fieldMonitor.path.length == step) {
                this.notifyFieldChangeListener(notifier, fieldMonitor, objects);
                continue;
            }
            int storageId = fieldMonitor.getStorageId(step);
            remainingMonitorsMap.computeIfAbsent(storageId, i -> new ArrayList()).add(fieldMonitor);
        }
        for (Map.Entry entry : remainingMonitorsMap.entrySet()) {
            int storageId = (Integer)entry.getKey();
            ArrayList monitors = (ArrayList)entry.getValue();
            assert (monitors != null);
            ArrayList<NavigableSet<ObjId>> refsList = new ArrayList<NavigableSet<ObjId>>(monitors.size());
            for (FieldMonitor monitor : (ArrayList)entry.getValue()) {
                refsList.addAll(this.traverseReference(objects, -storageId, monitor.getFilter(step + 1)));
            }
            if (refsList.isEmpty()) continue;
            this.notifyFieldMonitors(notifier, NavigableSets.union(refsList), monitors, step + 1);
        }
    }

    private <T> void notifyFieldChangeListener(FieldChangeNotifier<T> notifier, FieldMonitor monitor, NavigableSet<ObjId> objects) {
        T listener;
        try {
            listener = notifier.getListenerType().cast(monitor.listener);
        }
        catch (ClassCastException e) {
            return;
        }
        notifier.notify(this, listener, monitor.path, objects);
    }

    /*
     * WARNING - void declaration
     */
    public NavigableSet<ObjId> followReferencePath(Iterable<? extends ObjId> startObjects, int[] path, KeyRanges[] filters) {
        void var7_9;
        Preconditions.checkArgument((startObjects != null ? 1 : 0) != 0, (Object)"null startObjects");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"null path");
        Preconditions.checkArgument((filters == null || filters.length == path.length + 1 ? 1 : 0) != 0, (Object)"invalid filters length");
        ObjIdSet startIds = new ObjIdSet();
        KeyRanges firstFilter = filters != null ? filters[0] : null;
        for (ObjId objId : startObjects) {
            if (firstFilter != null && !firstFilter.contains(objId.getBytes())) continue;
            startIds.add(objId);
        }
        if (path.length == 0) {
            return startIds.sortedSnapshot();
        }
        Set<ObjId> ids = startIds;
        boolean bl = false;
        while (var7_9 < path.length) {
            int pathId = path[var7_9];
            KeyRanges filter = filters != null ? filters[var7_9 + true] : null;
            ArrayList<NavigableSet<ObjId>> refsList = this.traverseReference(ids, pathId, filter);
            if (refsList.isEmpty()) {
                return NavigableSets.empty((Comparator)FieldTypeRegistry.OBJ_ID);
            }
            ids = NavigableSets.union(refsList);
            ++var7_9;
        }
        return (NavigableSet)ids;
    }

    public NavigableSet<ObjId> invertReferencePath(int[] path, KeyRanges[] filters, Iterable<? extends ObjId> targetObjects) {
        KeyRanges[] invertedFilters;
        int[] invertedPath = new int[path.length];
        int i = 0;
        int j = path.length;
        while (i < path.length) {
            invertedPath[i++] = -path[--j];
        }
        if (filters != null) {
            invertedFilters = new KeyRanges[filters.length];
            i = 0;
            j = invertedFilters.length;
            while (i < invertedFilters.length) {
                invertedFilters[i++] = filters[--j];
            }
        } else {
            invertedFilters = null;
        }
        return this.followReferencePath(targetObjects, invertedPath, invertedFilters);
    }

    private ArrayList<NavigableSet<ObjId>> traverseReference(Iterable<? extends ObjId> objects, int referenceId, KeyRanges filter) {
        assert (objects != null);
        boolean inverse = referenceId < 0;
        int storageId = inverse ? -referenceId : referenceId;
        SimpleFieldStorageInfo<ObjId> info = this.verifyReferenceFieldStorageInfo(storageId);
        ArrayList<NavigableSet<ObjId>> refsList = new ArrayList<NavigableSet<ObjId>>();
        if (inverse) {
            AbstractCoreIndex index = info.getIndex(this);
            if (filter != null) {
                index = index.filter(1, (KeyFilter)filter);
            }
            NavigableMap<ObjId, NavigableSet<ObjId>> indexMap = index.asMap();
            for (ObjId objId : objects) {
                NavigableSet refs = (NavigableSet)indexMap.get(objId);
                if (refs == null) continue;
                refsList.add(refs);
            }
        } else {
            ObjIdSet refs = new ObjIdSet();
            Predicate<ObjId> idFilter = filter != null ? id -> filter.contains(id.getBytes()) : null;
            for (ObjId objId : objects) {
                info.readAllNonNull(this, objId, refs, idFilter);
            }
            if (!refs.isEmpty()) {
                refsList.add((NavigableSet<ObjId>)refs.sortedSnapshot());
            }
        }
        return refsList;
    }

    private void verifyReferencePath(int[] path) {
        for (int pathId : path) {
            int storageId = pathId < 0 ? -pathId : pathId;
            this.verifyReferenceFieldStorageInfo(storageId);
        }
    }

    private SimpleFieldStorageInfo<ObjId> verifyReferenceFieldStorageInfo(int storageId) {
        SimpleFieldStorageInfo info = this.schemas.verifyStorageInfo(storageId, SimpleFieldStorageInfo.class);
        if (!(info.fieldType instanceof ReferenceFieldType)) {
            throw new IllegalArgumentException(info + " is not a reference field");
        }
        return info;
    }

    public synchronized CoreIndex<?, ObjId> queryIndex(int storageId) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        SimpleFieldStorageInfo info = this.schemas.verifyStorageInfo(storageId, SimpleFieldStorageInfo.class);
        return info.getIndex(this);
    }

    public synchronized CoreIndex2<?, ObjId, Integer> queryListElementIndex(int storageId) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        ListElementStorageInfo info = this.schemas.verifyStorageInfo(storageId, ListElementStorageInfo.class);
        return info.getElementIndex(this);
    }

    public synchronized CoreIndex2<?, ObjId, ?> queryMapValueIndex(int storageId) {
        if (this.stale) {
            throw new StaleTransactionException(this);
        }
        MapValueStorageInfo info = this.schemas.verifyStorageInfo(storageId, MapValueStorageInfo.class);
        return info.getValueIndex(this);
    }

    public CoreIndex2<?, ?, ObjId> queryCompositeIndex2(int storageId) {
        CompositeIndexStorageInfo indexInfo = this.schemas.verifyStorageInfo(storageId, CompositeIndexStorageInfo.class);
        Object index = indexInfo.getIndex(this);
        if (!(index instanceof CoreIndex2)) {
            throw new UnknownIndexException(storageId, "the composite index with storage ID " + storageId + " is on " + indexInfo.storageIds.size() + " != 2 fields");
        }
        return (CoreIndex2)index;
    }

    public CoreIndex3<?, ?, ?, ObjId> queryCompositeIndex3(int storageId) {
        CompositeIndexStorageInfo indexInfo = this.schemas.verifyStorageInfo(storageId, CompositeIndexStorageInfo.class);
        Object index = indexInfo.getIndex(this);
        if (!(index instanceof CoreIndex3)) {
            throw new UnknownIndexException(storageId, "the composite index with storage ID " + storageId + " is on " + indexInfo.storageIds.size() + " != 3 fields");
        }
        return (CoreIndex3)index;
    }

    public CoreIndex4<?, ?, ?, ?, ObjId> queryCompositeIndex4(int storageId) {
        CompositeIndexStorageInfo indexInfo = this.schemas.verifyStorageInfo(storageId, CompositeIndexStorageInfo.class);
        Object index = indexInfo.getIndex(this);
        if (!(index instanceof CoreIndex4)) {
            throw new UnknownIndexException(storageId, "the composite index with storage ID " + storageId + " is on " + indexInfo.storageIds.size() + " != 4 fields");
        }
        return (CoreIndex4)index;
    }

    public Object queryCompositeIndex(int storageId) {
        CompositeIndexStorageInfo indexInfo = this.schemas.verifyStorageInfo(storageId, CompositeIndexStorageInfo.class);
        return indexInfo.getIndex(this);
    }

    private TreeMap<Integer, NavigableSet<ObjId>> findReferrers(ObjId target, DeleteAction onDelete) {
        assert (Thread.holdsLock(this));
        int targetStorageId = target.getStorageId();
        ArrayList versionList = new ArrayList(5);
        for (Map.Entry entry : this.queryVersion().asMap().entrySet()) {
            versionList.add(entry);
        }
        boolean multipleVersions = versionList.size() > 1;
        TreeMap<Integer, NavigableSet<ObjId>> result = new TreeMap<Integer, NavigableSet<ObjId>>();
        for (Map.Entry entry : versionList) {
            int schemaVersionNumber = (Integer)entry.getKey();
            NavigableSet schemaVersionRefs = (NavigableSet)entry.getValue();
            Schema schemaVersion = this.schemas.versions.get(schemaVersionNumber);
            if (schemaVersion == null) {
                throw new InconsistentDatabaseException("encountered objects with unknown schema version " + schemaVersionNumber);
            }
            for (Map.Entry<ReferenceField, KeyRanges> fieldRangeEntry : schemaVersion.deleteActionKeyRanges.get(onDelete.ordinal()).entrySet()) {
                ReferenceField field = fieldRangeEntry.getKey();
                KeyRanges keyRanges = fieldRangeEntry.getValue();
                SortedSet<Integer> targetTypes = field.getObjectTypes();
                if (targetTypes != null && !targetTypes.contains(targetStorageId)) continue;
                int fieldStorageId = field.storageId;
                ByteWriter writer = new ByteWriter(UnsignedIntEncoder.encodeLength((int)fieldStorageId) + 8);
                UnsignedIntEncoder.write((ByteWriter)writer, (int)fieldStorageId);
                target.writeTo(writer);
                byte[] prefix = writer.getBytes();
                IndexSet<ObjId> indexSet = new IndexSet<ObjId>((KVStore)this.kvt, FieldTypeRegistry.OBJ_ID, true, prefix);
                IndexSet<ObjId> referrers = keyRanges != null ? indexSet.filterKeys((KeyFilter)keyRanges) : indexSet;
                if (referrers.isEmpty()) continue;
                if (multipleVersions) {
                    ((ArrayList)result.computeIfAbsent(fieldStorageId, i -> new ArrayList(versionList.size()))).add(NavigableSets.intersection((NavigableSet[])new NavigableSet[]{schemaVersionRefs, referrers}));
                    continue;
                }
                result.put(fieldStorageId, (NavigableSet<ObjId>)((Object)referrers));
            }
        }
        if (multipleVersions) {
            for (Map.Entry entry : result.entrySet()) {
                ArrayList list = (ArrayList)entry.getValue();
                NavigableSet union = list.size() == 1 ? (NavigableSet)list.get(0) : NavigableSets.union((Iterable)list);
                entry.setValue(union);
            }
        }
        return result;
    }

    private byte[] buildCompositeIndexEntry(ObjId id, CompositeIndex index) {
        return Transaction.buildCompositeIndexEntry(this, id, index);
    }

    private static byte[] buildDefaultCompositeIndexEntry(ObjId id, CompositeIndex index) {
        return Transaction.buildCompositeIndexEntry(null, id, index);
    }

    private static byte[] buildCompositeIndexEntry(Transaction tx, ObjId id, CompositeIndex index) {
        ByteWriter writer = new ByteWriter();
        UnsignedIntEncoder.write((ByteWriter)writer, (int)index.storageId);
        for (SimpleField<?> field : index.fields) {
            byte[] value = tx != null ? tx.kvt.get(field.buildKey(id)) : null;
            writer.write(value != null ? value : field.fieldType.getDefaultValue());
        }
        id.writeTo(writer);
        return writer.getBytes();
    }

    public synchronized ListenerSet snapshotListeners() {
        return new ListenerSet(this);
    }

    public synchronized void setListeners(ListenerSet listeners) {
        Preconditions.checkArgument((listeners != null ? 1 : 0) != 0, (Object)"null listeners");
        if (listeners.monitorMap != null && !Arrays.equals(listeners.schema.encodedXML, this.schema.encodedXML) && !listeners.schema.schemaModel.isCompatibleWith(this.schema.schemaModel)) {
            throw new IllegalArgumentException("listener set was created from a transaction having an incompatible schema");
        }
        this.versionChangeListeners = listeners.versionChangeListeners;
        this.createListeners = listeners.createListeners;
        this.deleteListeners = listeners.deleteListeners;
        this.monitorMap = listeners.monitorMap;
        this.hasFieldMonitorCache = listeners.hasFieldMonitorCache;
        this.listenerSetInstalled = true;
    }

    public synchronized void setUserObject(Object obj) {
        this.userObject = obj;
    }

    public synchronized Object getUserObject() {
        return this.userObject;
    }

    private static final class MonitoredPredicate
    implements Predicate<FieldMonitor> {
        private final byte[] objTypeBytes;
        private final int fieldStorageId;

        MonitoredPredicate(int objTypeStorageId, int fieldStorageId) {
            this.objTypeBytes = ObjId.getMin(objTypeStorageId).getBytes();
            this.fieldStorageId = fieldStorageId;
        }

        @Override
        public boolean test(FieldMonitor monitor) {
            assert (monitor != null);
            if (monitor.storageId != this.fieldStorageId) {
                return false;
            }
            KeyRanges filter = monitor.getTargetFilter();
            return filter == null || filter.contains(this.objTypeBytes);
        }
    }

    public static final class ListenerSet {
        final Set<VersionChangeListener> versionChangeListeners;
        final Set<CreateListener> createListeners;
        final Set<DeleteListener> deleteListeners;
        final NavigableMap<Integer, Set<FieldMonitor>> monitorMap;
        final NavigableSet<Long> hasFieldMonitorCache;
        final Schema schema;

        private ListenerSet(Transaction tx) {
            assert (Thread.holdsLock(tx));
            this.versionChangeListeners = tx.versionChangeListeners != null ? Collections.unmodifiableSet(new HashSet(tx.versionChangeListeners)) : null;
            this.createListeners = tx.createListeners != null ? Collections.unmodifiableSet(new HashSet(tx.createListeners)) : null;
            Set<Object> set = this.deleteListeners = tx.deleteListeners != null ? Collections.unmodifiableSet(new HashSet(tx.deleteListeners)) : null;
            if (tx.monitorMap != null) {
                TreeMap monitorMapSnapshot = new TreeMap();
                for (Map.Entry entry : tx.monitorMap.entrySet()) {
                    monitorMapSnapshot.put(entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
                }
                this.monitorMap = Collections.unmodifiableNavigableMap(monitorMapSnapshot);
            } else {
                this.monitorMap = null;
            }
            this.hasFieldMonitorCache = tx.buildHasFieldMonitorCache();
            this.schema = tx.schema;
        }
    }

    public static class CallbackAdapter
    implements Callback {
        @Override
        public void beforeCommit(boolean readOnly) {
        }

        @Override
        public void beforeCompletion() {
        }

        @Override
        public void afterCommit() {
        }

        @Override
        public void afterCompletion(boolean committed) {
        }
    }

    public static interface Callback {
        public void beforeCommit(boolean var1);

        public void beforeCompletion();

        public void afterCommit();

        public void afterCompletion(boolean var1);
    }

    private static abstract class SimpleFieldChangeNotifier
    extends FieldChangeNotifier<SimpleFieldChangeListener> {
        SimpleFieldChangeNotifier(SimpleField<?> field, ObjId id) {
            super(SimpleFieldChangeListener.class, field.storageId, id);
        }
    }

    static interface Mutation<V> {
        public V mutate();
    }
}

