/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.jsimpledb.core.type.ArrayType;
import org.jsimpledb.core.type.PrimitiveType;
import org.jsimpledb.util.ParseContext;

public abstract class Base64ArrayType<T, E>
extends ArrayType<T, E> {
    private static final long serialVersionUID = -7770505941381986791L;
    private static final Pattern BASE64_PATTERN = Pattern.compile("(([-_+/\\p{Alnum}]\\s*){4})*(([-_+/\\p{Alnum}]\\s*){2}==|([-_+/\\p{Alnum}]\\s*){3}=|=)");
    private final int size;

    protected Base64ArrayType(PrimitiveType<E> elementType, TypeToken<T> typeToken) {
        super(elementType, typeToken);
        this.size = elementType.primitive.getSize();
    }

    @Override
    public T fromString(String string) {
        if (string.length() == 0) {
            return this.createArray(Collections.emptyList());
        }
        if (string.charAt(0) == '[') {
            return super.fromString(string);
        }
        return this.decodeString(string);
    }

    @Override
    public String toString(T array) {
        return this.encodeString(array).toString();
    }

    public String toString(T array, boolean base64) {
        return base64 ? this.toString(array) : super.toString(array);
    }

    @Override
    public String toParseableString(T array) {
        String s = this.encodeString(array);
        int length = s.length();
        if (length == 0 || s.charAt(length - 1) != '=') {
            s = s + '=';
        }
        return s;
    }

    public String toParseableString(T array, boolean base64) {
        return base64 ? this.toParseableString(array) : super.toParseableString(array);
    }

    @Override
    public T fromParseableString(ParseContext context) {
        if (context.peek() == '[') {
            return super.fromParseableString(context);
        }
        return this.decodeString(context.matchPrefix(BASE64_PATTERN).group());
    }

    private String encodeString(T array) {
        int length = this.getArrayLength(array);
        if (length == 0) {
            return "";
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream(length * this.size);
        try (DataOutputStream output = new DataOutputStream(buf);){
            this.encode(array, output);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        return Base64.encodeBase64String((byte[])buf.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T decodeString(String base64) {
        byte[] data = Base64.decodeBase64((String)base64);
        try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));){
            T t = this.decode(input, data.length);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    protected abstract void encode(T var1, DataOutputStream var2) throws IOException;

    protected abstract T decode(DataInputStream var1, int var2) throws IOException;

    protected T checkDecodeLength(int numBytes) {
        if (numBytes % this.size != 0) {
            throw new IllegalArgumentException(this.name + " input has length " + numBytes + " not a multiple of " + this.size);
        }
        return (T)Array.newInstance(this.elementType.getTypeToken().getRawType(), numBytes / this.size);
    }
}

