/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import org.dellroad.stuff.java.Primitive;
import org.dellroad.stuff.string.StringEncoder;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.type.PrimitiveType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.ParseContext;

public class CharacterType
extends PrimitiveType<Character> {
    private static final long serialVersionUID = -3328818464598650353L;

    public CharacterType() {
        super(Primitive.CHARACTER);
    }

    @Override
    public Character read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        int hi = reader.readByte();
        int lo = reader.readByte();
        return Character.valueOf((char)(hi << 8 | lo));
    }

    @Override
    public void write(ByteWriter writer, Character value) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        int hi = value.charValue() >> 8;
        int lo = value.charValue() & 0xFF;
        writer.writeByte(hi);
        writer.writeByte(lo);
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(2);
    }

    @Override
    public String toString(Character value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        return StringEncoder.encode((String)String.valueOf(value), (boolean)true);
    }

    @Override
    public Character fromString(String string) {
        String s = StringEncoder.decode((String)string);
        if (s.length() != 1) {
            throw new IllegalArgumentException("more than one character found");
        }
        return Character.valueOf(s.charAt(0));
    }

    @Override
    public String toParseableString(Character value) {
        return StringEncoder.enquote((String)String.valueOf(value));
    }

    @Override
    public Character fromParseableString(ParseContext context) {
        String s = StringEncoder.dequote((String)context.matchPrefix(StringEncoder.ENQUOTE_PATTERN).group());
        if (s.length() != 1) {
            throw context.buildException("more than one character found within quotation marks");
        }
        return Character.valueOf(s.charAt(0));
    }

    @Override
    public <S> Character convert(FieldType<S> type, S value) {
        if (value instanceof String && ((String)value).length() == 1) {
            return Character.valueOf(((String)value).charAt(0));
        }
        return (Character)super.convert(type, value);
    }

    @Override
    protected Character convertNumber(Number value) {
        return Character.valueOf((char)value.intValue());
    }
}

