/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;

abstract class Concat2Type<T, S1, S2>
extends NonNullFieldType<T> {
    private static final long serialVersionUID = -7395218884659436172L;
    protected final FieldType<S1> type1;
    protected final FieldType<S2> type2;

    protected Concat2Type(Class<T> type, long signature, T defaultValue, FieldType<S1> type1, FieldType<S2> type2) {
        super(type, signature, defaultValue);
        this.type1 = type1;
        this.type2 = type2;
    }

    protected Concat2Type(Class<T> type, long signature, FieldType<S1> type1, FieldType<S2> type2) {
        this(type, signature, null, type1, type2);
    }

    @Override
    public T read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return this.join(this.type1.read(reader), this.type2.read(reader));
    }

    @Override
    public void write(ByteWriter writer, T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        this.type1.write(writer, this.split1(value));
        this.type2.write(writer, this.split2(value));
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        this.type1.skip(reader);
        this.type2.skip(reader);
    }

    @Override
    public int compare(T value1, T value2) {
        int diff = this.type1.compare(this.split1(value1), this.split1(value2));
        if (diff != 0) {
            return diff;
        }
        return this.type2.compare(this.split2(value1), this.split2(value2));
    }

    @Override
    public boolean hasPrefix0x00() {
        return this.type1.hasPrefix0x00();
    }

    @Override
    public boolean hasPrefix0xff() {
        return this.type1.hasPrefix0xff();
    }

    protected abstract T join(S1 var1, S2 var2);

    protected abstract S1 split1(T var1);

    protected abstract S2 split2(T var1);
}

