/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import org.dellroad.stuff.java.Primitive;
import org.jsimpledb.core.type.NumberType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;

public class DoubleType
extends NumberType<Double> {
    private static final long serialVersionUID = 7124114664265270273L;
    private static final long POS_XOR = Long.MIN_VALUE;
    private static final long NEG_XOR = -1L;
    private static final long SIGN_BIT = Long.MIN_VALUE;

    public DoubleType() {
        super(Primitive.DOUBLE);
    }

    @Override
    public Double read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        long bits = ByteUtil.readLong((ByteReader)reader);
        return Double.longBitsToDouble(bits ^= (bits & Long.MIN_VALUE) == 0L ? -1L : Long.MIN_VALUE);
    }

    @Override
    public void write(ByteWriter writer, Double value) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        long bits = Double.doubleToLongBits(value);
        ByteUtil.writeLong((ByteWriter)writer, (long)(bits ^= (bits & Long.MIN_VALUE) != 0L ? -1L : Long.MIN_VALUE));
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(8);
    }

    @Override
    public Double validate(Object obj) {
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Float || obj instanceof Long) {
            return ((Number)obj).doubleValue();
        }
        return (Double)super.validate(obj);
    }

    @Override
    protected Double convertNumber(Number value) {
        return value.doubleValue();
    }
}

