/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Floats;
import com.google.common.reflect.TypeToken;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.type.Base64ArrayType;
import org.jsimpledb.core.type.FloatType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;

public class FloatArrayType
extends Base64ArrayType<float[], Float> {
    private static final long serialVersionUID = 2791855034086017414L;
    private static final int NUM_BYTES = 4;
    private static final byte[] END = new byte[4];
    private final FloatType floatType = new FloatType();

    public FloatArrayType() {
        super(FieldTypeRegistry.FLOAT, new TypeToken<float[]>(){});
    }

    @Override
    public float[] read(ByteReader reader) {
        byte[] next;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        ArrayList<Float> list = new ArrayList<Float>();
        while (!Arrays.equals(next = reader.readBytes(4), END)) {
            list.add(this.floatType.read(new ByteReader(next)));
        }
        return this.createArray((List<Float>)list);
    }

    @Override
    public void write(ByteWriter writer, float[] array) {
        Preconditions.checkArgument((array != null ? 1 : 0) != 0, (Object)"null array");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        int length = this.getArrayLength(array);
        for (int i = 0; i < length; ++i) {
            this.floatType.write(writer, Float.valueOf(array[i]));
        }
        writer.write(END);
    }

    @Override
    public void skip(ByteReader reader) {
        byte[] next;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        while (!Arrays.equals(next = reader.readBytes(4), END)) {
        }
    }

    @Override
    public boolean hasPrefix0xff() {
        return this.floatType.hasPrefix0xff();
    }

    @Override
    protected int getArrayLength(float[] array) {
        return array.length;
    }

    @Override
    protected Float getArrayElement(float[] array, int index) {
        return Float.valueOf(array[index]);
    }

    @Override
    protected float[] createArray(List<Float> elements) {
        return Floats.toArray(elements);
    }

    @Override
    protected void encode(float[] array, DataOutputStream output) throws IOException {
        for (float value : array) {
            output.writeFloat(value);
        }
    }

    @Override
    protected float[] decode(DataInputStream input, int numBytes) throws IOException {
        float[] array = (float[])this.checkDecodeLength(numBytes);
        for (int i = 0; i < array.length; ++i) {
            array[i] = input.readFloat();
        }
        return array;
    }
}

