/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import org.dellroad.stuff.java.Primitive;
import org.jsimpledb.core.type.NumberType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;

public class FloatType
extends NumberType<Float> {
    private static final long serialVersionUID = 4726406311612739536L;
    private static final byte[] DEFAULT_VALUE = new byte[]{-128, 0, 0, 0};
    private static final int POS_XOR = Integer.MIN_VALUE;
    private static final int NEG_XOR = -1;
    private static final int SIGN_BIT = Integer.MIN_VALUE;

    public FloatType() {
        super(Primitive.FLOAT);
    }

    @Override
    public Float read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        int bits = ByteUtil.readInt((ByteReader)reader);
        return Float.valueOf(Float.intBitsToFloat(bits ^= (bits & Integer.MIN_VALUE) == 0 ? -1 : Integer.MIN_VALUE));
    }

    @Override
    public void write(ByteWriter writer, Float value) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        int bits = Float.floatToIntBits(value.floatValue());
        ByteUtil.writeInt((ByteWriter)writer, (int)(bits ^= (bits & Integer.MIN_VALUE) != 0 ? -1 : Integer.MIN_VALUE));
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(4);
    }

    @Override
    public Float validate(Object obj) {
        if (obj instanceof Character) {
            return Float.valueOf(((Character)obj).charValue());
        }
        if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long) {
            return Float.valueOf(((Number)obj).floatValue());
        }
        return (Float)super.validate(obj);
    }

    @Override
    protected Float convertNumber(Number value) {
        return Float.valueOf(value.floatValue());
    }
}

