/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import java.time.Period;
import java.util.regex.Pattern;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.LongEncoder;
import org.jsimpledb.util.ParseContext;

public class PeriodType
extends NonNullFieldType<Period> {
    private static final Pattern PATTERN = Pattern.compile("P(-?[0-9]+Y)?(-?[0-9]+M)?(-?[0-9]+?D)?|P-?[0-9]+W");
    private static final long serialVersionUID = -5481674489895732054L;

    public PeriodType() {
        super(Period.class, 0L, Period.ZERO);
    }

    @Override
    public Period read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return Period.of((int)LongEncoder.read((ByteReader)reader), (int)LongEncoder.read((ByteReader)reader), (int)LongEncoder.read((ByteReader)reader));
    }

    @Override
    public void write(ByteWriter writer, Period period) {
        Preconditions.checkArgument((period != null ? 1 : 0) != 0, (Object)"null period");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        LongEncoder.write((ByteWriter)writer, (long)period.getYears());
        LongEncoder.write((ByteWriter)writer, (long)period.getMonths());
        LongEncoder.write((ByteWriter)writer, (long)period.getDays());
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public Period fromParseableString(ParseContext ctx) {
        return Period.parse(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(Period period) {
        return period.toString();
    }

    @Override
    public int compare(Period period1, Period period2) {
        int diff = Integer.compare(period1.getYears(), period2.getYears());
        if (diff != 0) {
            return diff;
        }
        diff = Integer.compare(period1.getMonths(), period2.getMonths());
        if (diff != 0) {
            return diff;
        }
        diff = Integer.compare(period1.getDays(), period2.getDays());
        if (diff != 0) {
            return diff;
        }
        return 0;
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

