/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import org.dellroad.stuff.string.StringEncoder;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.type.CharacterArrayType;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.core.type.NullSafeType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.ParseContext;
import org.jsimpledb.util.UnsignedIntEncoder;

public class StringType
extends NonNullFieldType<String> {
    private static final long serialVersionUID = -7808183397158645337L;
    private static final int END = 0;
    private static final int ESCAPE = 1;

    public StringType() {
        super(String.class, 0L);
    }

    @Override
    public String read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        StringBuilder buf = new StringBuilder();
        while (true) {
            int ch = UnsignedIntEncoder.read((ByteReader)reader);
            switch (ch) {
                case 0: {
                    return buf.toString();
                }
                case 1: {
                    int ch2 = reader.readByte();
                    if ((ch2 & 0xFFFFFFFE) != 0) {
                        throw new IllegalArgumentException(String.format("invalid string escape sequence 0x%02x 0x%02x", ch, ch2));
                    }
                    ch = ch2;
                    break;
                }
                default: {
                    if ((ch & 0xFFFF0000) == 0) break;
                    throw new IllegalArgumentException(String.format("read out of range string character value 0x%08x", ch));
                }
            }
            buf.append((char)ch);
        }
    }

    @Override
    public void write(ByteWriter writer, String value) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        int max = value.length();
        block3: for (int i = 0; i < max; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\u0000': 
                case '\u0001': {
                    writer.writeByte(1);
                    writer.writeByte((int)ch);
                    continue block3;
                }
                default: {
                    UnsignedIntEncoder.write((ByteWriter)writer, (int)ch);
                }
            }
        }
        writer.writeByte(0);
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        int value = reader.readByte();
        while (true) {
            switch (value) {
                case 0: {
                    return;
                }
                case 1: {
                    reader.skip(1);
                    break;
                }
                default: {
                    reader.skip(UnsignedIntEncoder.decodeLength((int)value) - 1);
                }
            }
            value = reader.readByte();
        }
    }

    @Override
    public String toString(String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        return StringEncoder.encode((String)value, (boolean)false);
    }

    @Override
    public String fromString(String string) {
        return StringEncoder.decode((String)string);
    }

    @Override
    public String toParseableString(String value) {
        return StringEncoder.enquote((String)value);
    }

    @Override
    public String fromParseableString(ParseContext ctx) {
        return StringEncoder.dequote((String)ctx.matchPrefix(StringEncoder.ENQUOTE_PATTERN).group());
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }

    @Override
    public int compare(String string1, String string2) {
        return string1.compareTo(string2);
    }

    @Override
    public <S> String convert(FieldType<S> type, S value) {
        if (value == null) {
            return null;
        }
        if (type instanceof NullSafeType) {
            type = ((NullSafeType)type).inner;
        }
        if (value instanceof Character) {
            return new String(new char[]{((Character)value).charValue()});
        }
        if (type instanceof CharacterArrayType) {
            return new String((char[])value);
        }
        return (String)super.convert(type, value);
    }
}

