/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import java.time.ZoneOffset;
import java.util.regex.Pattern;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.LongEncoder;
import org.jsimpledb.util.ParseContext;

public class ZoneOffsetType
extends NonNullFieldType<ZoneOffset> {
    static final Pattern PATTERN = Pattern.compile("(Z|[-+][0-9]{2}:[0-9]{2}(:[0-9]{2})?)");
    private static final long serialVersionUID = 4606196393878370203L;

    public ZoneOffsetType() {
        super(ZoneOffset.class, 0L);
    }

    @Override
    public ZoneOffset read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return ZoneOffset.ofTotalSeconds(-((int)LongEncoder.read((ByteReader)reader)));
    }

    @Override
    public void write(ByteWriter writer, ZoneOffset zoneOffset) {
        Preconditions.checkArgument((zoneOffset != null ? 1 : 0) != 0, (Object)"null zoneOffset");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        LongEncoder.write((ByteWriter)writer, (long)(-zoneOffset.getTotalSeconds()));
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public ZoneOffset fromParseableString(ParseContext ctx) {
        return ZoneOffset.of(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(ZoneOffset zoneOffset) {
        return zoneOffset.getId();
    }

    @Override
    public int compare(ZoneOffset zoneOffset1, ZoneOffset zoneOffset2) {
        return zoneOffset1.compareTo(zoneOffset2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

