/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.util;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.util.ObjIdMap;
import org.jsimpledb.util.ImmutableNavigableSet;

@NotThreadSafe
public class ObjIdSet
extends AbstractSet<ObjId>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8245070561628904936L;
    private ObjIdMap<?> map;

    public ObjIdSet() {
        this(0);
    }

    public ObjIdSet(int capacity) {
        this(new ObjIdMap(capacity, false));
    }

    public ObjIdSet(Iterable<? extends ObjId> ids) {
        this(0);
        Preconditions.checkArgument((ids != null ? 1 : 0) != 0, (Object)"null ids");
        for (ObjId objId : ids) {
            this.add(objId);
        }
    }

    ObjIdSet(ObjIdMap<?> map) {
        this.map = map;
    }

    public ObjId removeOne() {
        Map.Entry<ObjId, ?> entry = this.map.removeOne();
        return entry != null ? entry.getKey() : null;
    }

    @Override
    public Iterator<ObjId> iterator() {
        return new Iterator<ObjId>(){
            private final ObjIdMap.EntrySetIterator entryIterator;
            {
                this.entryIterator = ObjIdSet.this.map.new ObjIdMap.EntrySetIterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public ObjId next() {
                return (ObjId)this.entryIterator.next().getKey();
            }

            @Override
            public void remove() {
                this.entryIterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    @Override
    public boolean add(ObjId id) {
        if (this.map.containsKey(id)) {
            return false;
        }
        this.map.put(id, null);
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        if (!this.map.containsKey(obj)) {
            return false;
        }
        this.map.remove(obj);
        return true;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public ObjId[] toArray() {
        return this.map.toKeysArray();
    }

    public ImmutableNavigableSet<ObjId> sortedSnapshot() {
        Object[] array = this.toArray();
        Arrays.sort(array);
        return new ImmutableNavigableSet(array, ObjId::compareTo);
    }

    String debugDump() {
        return this.map.debugDump();
    }

    @Override
    public int hashCode() {
        long[] keyArray = this.map.getKeys();
        int hash = 0;
        for (long key : keyArray) {
            if (key == 0L) continue;
            hash += Long.hashCode(key);
        }
        return hash;
    }

    public ObjIdSet clone() {
        ObjIdSet clone;
        try {
            clone = (ObjIdSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.map = clone.map.clone();
        return clone;
    }
}

