/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SequencedCollection;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dellroad.stuff.xml.IndentXMLStreamWriter;
import org.jsimpledb.core.CollectionField;
import org.jsimpledb.core.CounterField;
import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ListField;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.ReferenceField;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SchemaItem;
import org.jsimpledb.core.SetField;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.SnapshotTransaction;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.UnknownTypeException;
import org.jsimpledb.core.util.GeneratedIdCache;
import org.jsimpledb.core.util.ObjIdMap;
import org.jsimpledb.schema.NameIndex;
import org.jsimpledb.schema.SchemaField;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.schema.SchemaObjectType;
import org.jsimpledb.util.AbstractXMLStreaming;
import org.jsimpledb.util.ByteWriter;

public class XMLObjectSerializer
extends AbstractXMLStreaming {
    public static final QName ELEMENT_TAG = new QName("element");
    public static final QName ENTRY_TAG = new QName("entry");
    public static final QName FIELD_TAG = new QName("field");
    public static final QName KEY_TAG = new QName("key");
    public static final QName OBJECTS_TAG = new QName("objects");
    public static final QName OBJECT_TAG = new QName("object");
    public static final QName VALUE_TAG = new QName("value");
    public static final QName ID_ATTR = new QName("id");
    public static final QName STORAGE_ID_ATTR = new QName("storageId");
    public static final QName VERSION_ATTR = new QName("version");
    public static final QName NULL_ATTR = new QName("null");
    private static final Pattern GENERATED_ID_PATTERN = Pattern.compile("generated:([^:]+):(.*)");
    private final Transaction tx;
    private final HashMap<Integer, NameIndex> nameIndexMap = new HashMap();
    private GeneratedIdCache generatedIdCache = new GeneratedIdCache();
    private final ObjIdMap<ReferenceField> unresolvedReferences = new ObjIdMap();
    private int fieldTruncationLength = -1;

    public XMLObjectSerializer(Transaction tx) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        this.tx = tx;
        for (Schema schema : this.tx.getSchemas().getVersions().values()) {
            this.nameIndexMap.put(schema.getVersionNumber(), new NameIndex(schema.getSchemaModel()));
        }
    }

    public int getFieldTruncationLength() {
        return this.fieldTruncationLength;
    }

    public void setFieldTruncationLength(int length) {
        Preconditions.checkArgument((length >= -1 ? 1 : 0) != 0, (Object)"length < -1");
        this.fieldTruncationLength = length;
    }

    public ObjIdMap<ReferenceField> getUnresolvedReferences() {
        return this.unresolvedReferences;
    }

    public GeneratedIdCache getGeneratedIdCache() {
        return this.generatedIdCache;
    }

    public void setGeneratedIdCache(GeneratedIdCache generatedIdCache) {
        Preconditions.checkArgument((generatedIdCache != null ? 1 : 0) != 0, (Object)"null generatedIdCache");
        this.generatedIdCache = generatedIdCache;
    }

    public int read(InputStream input) throws XMLStreamException {
        return this.read(input, false);
    }

    public int read(InputStream input, boolean allowUnresolvedReferences) throws XMLStreamException {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        int count = this.read(XMLInputFactory.newFactory().createXMLStreamReader(input));
        if (!allowUnresolvedReferences && !this.unresolvedReferences.isEmpty()) {
            throw new DeletedObjectException(this.unresolvedReferences.keySet().iterator().next(), this.unresolvedReferences.size() + " unresolved reference(s) remain");
        }
        return count;
    }

    public int read(XMLStreamReader reader) throws XMLStreamException {
        QName name;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"null reader");
        this.expect(reader, false, new QName[]{OBJECTS_TAG});
        SnapshotTransaction snapshot = this.tx.createSnapshotTransaction();
        int count = 0;
        while ((name = this.next(reader)) != null) {
            ObjId id;
            Schema schema;
            String versionAttr = this.getAttr(reader, VERSION_ATTR, false);
            if (versionAttr != null) {
                try {
                    schema = this.tx.getSchemas().getVersion(Integer.parseInt(versionAttr));
                }
                catch (IllegalArgumentException e) {
                    throw new XMLStreamException("invalid object schema version `" + versionAttr + "': " + e, reader.getLocation(), e);
                }
            } else {
                schema = this.tx.getSchema();
            }
            NameIndex nameIndex = this.nameIndexMap.get(schema.getVersionNumber());
            SchemaModel schemaModel = schema.getSchemaModel();
            String storageIdAttr = this.getAttr(reader, STORAGE_ID_ATTR, false);
            ObjType objType = null;
            if (storageIdAttr != null) {
                try {
                    objType = schema.getObjType(Integer.parseInt(storageIdAttr));
                }
                catch (UnknownTypeException e) {
                    throw new XMLStreamException("invalid object type storage ID `" + storageIdAttr + "': " + e, reader.getLocation(), e);
                }
                if (!name.equals(OBJECT_TAG)) {
                    if (!"".equals(name.getNamespaceURI())) {
                        throw new XMLStreamException("unexpected element <" + name.getPrefix() + ":" + name.getLocalPart() + ">; expected <" + OBJECT_TAG.getLocalPart() + ">", reader.getLocation());
                    }
                    if (!objType.getName().equals(name.getLocalPart())) {
                        throw new XMLStreamException("element <" + name.getLocalPart() + "> does not match storage ID " + objType.getStorageId() + "; should be <" + objType.getName() + ">", reader.getLocation());
                    }
                }
            } else {
                if (!"".equals(name.getNamespaceURI())) {
                    throw new XMLStreamException("unexpected element <" + name.getPrefix() + ":" + name.getLocalPart() + ">; expected <object> or object type name", reader.getLocation());
                }
                if (!name.equals(OBJECT_TAG)) {
                    SchemaObjectType schemaObjectType = nameIndex.getSchemaObjectType(name.getLocalPart());
                    if (schemaObjectType == null) {
                        throw new XMLStreamException("unexpected element <" + name.getLocalPart() + ">; no object type named `" + name.getLocalPart() + "' found in schema version " + schema.getVersionNumber(), reader.getLocation());
                    }
                    objType = schema.getObjType(schemaObjectType.getStorageId());
                }
            }
            snapshot.reset();
            String idAttr = this.getAttr(reader, ID_ATTR, false);
            if (idAttr == null) {
                if (objType == null) {
                    throw new XMLStreamException("invalid <" + OBJECT_TAG.getLocalPart() + "> element: either \"" + STORAGE_ID_ATTR.getLocalPart() + "\" or \"" + ID_ATTR.getLocalPart() + "\" attribute is required", reader.getLocation());
                }
                id = snapshot.create(objType.getStorageId(), schema.getVersionNumber());
            } else {
                try {
                    id = new ObjId(idAttr);
                }
                catch (IllegalArgumentException e) {
                    Matcher matcher = GENERATED_ID_PATTERN.matcher(idAttr);
                    if (!matcher.matches()) {
                        throw new XMLStreamException("invalid object ID `" + idAttr + "'", reader.getLocation());
                    }
                    String typeAttr = matcher.group(1);
                    ObjType genType = this.parseGeneratedType(reader, idAttr, typeAttr, schema);
                    if (objType == null) {
                        objType = genType;
                    } else if (!genType.equals(objType)) {
                        throw new XMLStreamException("type `" + typeAttr + "' in generated object ID `" + idAttr + "' does not match type `" + objType.getName() + "' in schema version " + schema.getVersionNumber(), reader.getLocation());
                    }
                    id = this.generatedIdCache.getGeneratedId(this.tx, objType.getStorageId(), matcher.group(2));
                }
                snapshot.create(id, schema.getVersionNumber());
            }
            SchemaObjectType schemaObjectType = (SchemaObjectType)schemaModel.getSchemaObjectTypes().get(objType.getStorageId());
            while ((name = this.next(reader)) != null) {
                Field field;
                QName fieldTagName = name;
                storageIdAttr = this.getAttr(reader, STORAGE_ID_ATTR, false);
                if (storageIdAttr != null) {
                    try {
                        field = (Field)objType.getFields().get(Integer.parseInt(storageIdAttr));
                    }
                    catch (IllegalArgumentException e) {
                        throw new XMLStreamException("invalid field storage ID `" + storageIdAttr + "': " + e, reader.getLocation(), e);
                    }
                    if (field == null) {
                        throw new XMLStreamException("unknown field storage ID `" + storageIdAttr + "' for object type `" + objType.getName() + "' #" + objType.getStorageId() + " in schema version " + schema.getVersionNumber(), reader.getLocation());
                    }
                } else {
                    if (!"".equals(name.getNamespaceURI())) {
                        throw new XMLStreamException("unexpected element <" + name.getPrefix() + ":" + name.getLocalPart() + ">; expected field name", reader.getLocation());
                    }
                    SchemaField schemaField = nameIndex.getSchemaField(schemaObjectType, name.getLocalPart());
                    if (schemaField == null) {
                        throw new XMLStreamException("unexpected element <" + name.getLocalPart() + ">; unknown field `" + name.getLocalPart() + "' in object type `" + objType.getName() + "' #" + objType.getStorageId() + " in schema version " + schema.getVersionNumber(), reader.getLocation());
                    }
                    field = (Field)objType.getFields().get(schemaField.getStorageId());
                    assert (field != null) : "field=" + schemaField + " fields=" + objType.getFields();
                }
                if (field instanceof SimpleField) {
                    snapshot.writeSimpleField(id, field.getStorageId(), this.readSimpleField(reader, (SimpleField)field), false);
                    continue;
                }
                if (field instanceof CounterField) {
                    long value;
                    try {
                        value = Long.parseLong(reader.getElementText());
                    }
                    catch (Exception e) {
                        throw new XMLStreamException("invalid counter value for field `" + field.getName() + "': " + e, reader.getLocation(), e);
                    }
                    snapshot.writeCounterField(id, field.getStorageId(), value, false);
                    continue;
                }
                if (field instanceof CollectionField) {
                    SequencedCollection<?> collection;
                    SimpleField elementField = ((CollectionField)field).getElementField();
                    if (field instanceof SetField) {
                        collection = snapshot.readSetField(id, field.getStorageId(), false);
                    } else if (field instanceof ListField) {
                        collection = snapshot.readListField(id, field.getStorageId(), false);
                    } else {
                        throw new RuntimeException("internal error: " + field);
                    }
                    while ((name = this.next(reader)) != null) {
                        if (!ELEMENT_TAG.equals(name)) {
                            throw new XMLStreamException("invalid field element; expected <" + ELEMENT_TAG.getLocalPart() + "> but found opening <" + name.getLocalPart() + ">", reader.getLocation());
                        }
                        collection.add(this.readSimpleField(reader, elementField));
                    }
                    continue;
                }
                if (field instanceof MapField) {
                    SimpleField keyField = ((MapField)field).getKeyField();
                    SimpleField valueField = ((MapField)field).getValueField();
                    NavigableMap<?, ?> map = snapshot.readMapField(id, field.getStorageId(), false);
                    while ((name = this.next(reader)) != null) {
                        if (!ENTRY_TAG.equals(name)) {
                            throw new XMLStreamException("invalid map field entry; expected <" + ENTRY_TAG.getLocalPart() + "> but found opening <" + name.getLocalPart() + ">", reader.getLocation());
                        }
                        if (!KEY_TAG.equals(this.next(reader))) {
                            throw new XMLStreamException("invalid map entry key; expected <" + KEY_TAG.getLocalPart() + ">", reader.getLocation());
                        }
                        Object key = this.readSimpleField(reader, keyField);
                        if (!VALUE_TAG.equals(this.next(reader))) {
                            throw new XMLStreamException("invalid map entry value; expected <" + VALUE_TAG.getLocalPart() + ">", reader.getLocation());
                        }
                        Object value = this.readSimpleField(reader, valueField);
                        map.put(key, value);
                        name = this.next(reader);
                        if (name == null) continue;
                        throw new XMLStreamException("invalid map field entry; expected closing <" + ENTRY_TAG.getLocalPart() + "> but found opening <" + name.getLocalPart() + ">", reader.getLocation());
                    }
                    continue;
                }
                throw new RuntimeException("internal error: " + field);
            }
            snapshot.copy(id, this.tx, false, false, this.unresolvedReferences, null);
            this.unresolvedReferences.remove(id);
            ++count;
        }
        return count;
    }

    public int write(OutputStream output, boolean nameFormat, boolean indent) throws XMLStreamException {
        Preconditions.checkArgument((output != null ? 1 : 0) != 0, (Object)"null output");
        XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(output, "UTF-8");
        if (indent) {
            xmlWriter = new IndentXMLStreamWriter(xmlWriter);
        }
        xmlWriter.writeStartDocument("UTF-8", "1.0");
        return this.write(xmlWriter, nameFormat);
    }

    public int write(Writer writer, boolean nameFormat, boolean indent) throws XMLStreamException {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0, (Object)"null writer");
        XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
        if (indent) {
            xmlWriter = new IndentXMLStreamWriter(xmlWriter);
        }
        xmlWriter.writeStartDocument("1.0");
        return this.write(xmlWriter, nameFormat);
    }

    private int write(XMLStreamWriter writer, boolean nameFormat) throws XMLStreamException {
        TreeSet storageIds = new TreeSet();
        for (Schema schema : this.tx.getSchemas().getVersions().values()) {
            storageIds.addAll(schema.getSchemaModel().getSchemaObjectTypes().keySet());
        }
        ArrayList sets = storageIds.stream().map(this.tx::getAll).collect(Collectors.toCollection(() -> new ArrayList(storageIds.size())));
        return this.write(writer, nameFormat, Iterables.concat((Iterable)sets));
    }

    public int write(XMLStreamWriter writer, boolean nameFormat, Iterable<? extends ObjId> objIds) throws XMLStreamException {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0, (Object)"null writer");
        Preconditions.checkArgument((objIds != null ? 1 : 0) != 0, (Object)"null objIds");
        writer.setDefaultNamespace(OBJECTS_TAG.getNamespaceURI());
        writer.writeStartElement(OBJECTS_TAG.getNamespaceURI(), OBJECTS_TAG.getLocalPart());
        int count = 0;
        for (ObjId objId : objIds) {
            int typeStorageId = objId.getStorageId();
            int version = this.tx.getSchemaVersion(objId);
            Schema schema = this.tx.getSchemas().getVersion(version);
            ObjType objType = schema.getObjType(typeStorageId);
            QName objectElement = nameFormat ? new QName(objType.getName()) : OBJECT_TAG;
            int storageIdAttr = nameFormat ? -1 : typeStorageId;
            boolean tagOutput = false;
            ArrayList fieldList = new ArrayList(objType.getFields().values());
            if (nameFormat) {
                Collections.sort(fieldList, Comparator.comparing(SchemaItem::getName));
            }
            for (Field<?> field : fieldList) {
                QName fieldTag;
                if (field.hasDefaultValue(this.tx, objId)) continue;
                if (!tagOutput) {
                    this.writeOpenTag(writer, false, objectElement, storageIdAttr, objId, version);
                    tagOutput = true;
                }
                QName qName = fieldTag = nameFormat ? new QName(field.getName()) : FIELD_TAG;
                if (field instanceof SimpleField) {
                    Object value = this.tx.readSimpleField(objId, field.getStorageId(), false);
                    if (value == null || this.fieldTruncationLength == 0) {
                        writer.writeEmptyElement(fieldTag.getNamespaceURI(), fieldTag.getLocalPart());
                    } else {
                        writer.writeStartElement(fieldTag.getNamespaceURI(), fieldTag.getLocalPart());
                    }
                    if (!nameFormat) {
                        this.writeAttribute(writer, STORAGE_ID_ATTR, field.getStorageId());
                    }
                    if (value != null && this.fieldTruncationLength != 0) {
                        this.writeSimpleFieldText(writer, (SimpleField)field, value);
                        writer.writeEndElement();
                        continue;
                    }
                    if (value != null) continue;
                    this.writeAttribute(writer, NULL_ATTR, "true");
                    continue;
                }
                writer.writeStartElement(fieldTag.getNamespaceURI(), fieldTag.getLocalPart());
                if (!nameFormat) {
                    this.writeAttribute(writer, STORAGE_ID_ATTR, field.getStorageId());
                }
                if (field instanceof CounterField) {
                    writer.writeCharacters("" + this.tx.readCounterField(objId, field.getStorageId(), false));
                } else if (field instanceof CollectionField) {
                    SimpleField elementField = ((CollectionField)field).getElementField();
                    SequencedCollection<?> collection = field instanceof SetField ? this.tx.readSetField(objId, field.getStorageId(), false) : this.tx.readListField(objId, field.getStorageId(), false);
                    for (Object object : collection) {
                        this.writeSimpleTag(writer, ELEMENT_TAG, elementField, object);
                    }
                } else if (field instanceof MapField) {
                    SimpleField keyField = ((MapField)field).getKeyField();
                    SimpleField valueField = ((MapField)field).getValueField();
                    for (Map.Entry entry : this.tx.readMapField(objId, field.getStorageId(), false).entrySet()) {
                        writer.writeStartElement(ENTRY_TAG.getNamespaceURI(), ENTRY_TAG.getLocalPart());
                        this.writeSimpleTag(writer, KEY_TAG, keyField, entry.getKey());
                        this.writeSimpleTag(writer, VALUE_TAG, valueField, entry.getValue());
                        writer.writeEndElement();
                    }
                } else {
                    throw new RuntimeException("internal error: " + field);
                }
                writer.writeEndElement();
            }
            if (!tagOutput) {
                this.writeOpenTag(writer, true, objectElement, storageIdAttr, objId, version);
            } else {
                writer.writeEndElement();
            }
            ++count;
        }
        writer.writeEndElement();
        writer.flush();
        return count;
    }

    private <T> boolean isDefaultValue(SimpleField<T> field, Object value) throws XMLStreamException {
        ByteWriter writer = new ByteWriter();
        FieldType<T> fieldType = field.getFieldType();
        fieldType.write(writer, fieldType.validate(value));
        return Arrays.equals(writer.getBytes(), field.getFieldType().getDefaultValue());
    }

    private void writeSimpleTag(XMLStreamWriter writer, QName tag, SimpleField<?> field, Object value) throws XMLStreamException {
        if (value != null && this.fieldTruncationLength != 0) {
            writer.writeStartElement(tag.getNamespaceURI(), tag.getLocalPart());
            this.writeSimpleFieldText(writer, field, value);
            writer.writeEndElement();
        } else {
            writer.writeEmptyElement(tag.getNamespaceURI(), tag.getLocalPart());
            if (value == null) {
                this.writeAttribute(writer, NULL_ATTR, "true");
            }
        }
    }

    private <T> void writeSimpleFieldText(XMLStreamWriter writer, SimpleField<T> field, Object value) throws XMLStreamException {
        FieldType<T> fieldType = field.getFieldType();
        String text = fieldType.toString(fieldType.validate(value));
        int length = text.length();
        if (this.fieldTruncationLength == -1 || length <= this.fieldTruncationLength) {
            writer.writeCharacters(text);
            return;
        }
        writer.writeCharacters(text.substring(0, this.fieldTruncationLength));
        writer.writeCharacters("...[truncated]");
    }

    private <T> T readSimpleField(XMLStreamReader reader, SimpleField<T> field) throws XMLStreamException {
        Matcher matcher;
        String text;
        FieldType<T> fieldType = field.getFieldType();
        String nullAttr = this.getAttr(reader, NULL_ATTR, false);
        boolean isNull = false;
        if (nullAttr != null) {
            switch (nullAttr) {
                case "true": 
                case "false": {
                    isNull = Boolean.valueOf(nullAttr);
                    break;
                }
                default: {
                    throw new XMLStreamException("invalid value `" + nullAttr + "' for `" + NULL_ATTR.getLocalPart() + "' attribute: value must be \"true\" or \"false\"", reader.getLocation());
                }
            }
        }
        try {
            text = reader.getElementText();
        }
        catch (Exception e) {
            throw new XMLStreamException("invalid value for field `" + field.getName() + "': " + e, reader.getLocation(), e);
        }
        if (isNull) {
            if (text.length() != 0) {
                throw new XMLStreamException("text content not allowed for values with null=\"true\"", reader.getLocation());
            }
            return null;
        }
        if (field instanceof ReferenceField && (matcher = GENERATED_ID_PATTERN.matcher(text)).matches()) {
            int storageId = this.parseGeneratedType(reader, text, matcher.group(1));
            return fieldType.validate(this.generatedIdCache.getGeneratedId(this.tx, storageId, matcher.group(2)));
        }
        try {
            return fieldType.fromString(text);
        }
        catch (Exception e) {
            throw new XMLStreamException("invalid value `" + text + "' for field `" + field.getName() + "': " + e, reader.getLocation(), e);
        }
    }

    private int parseGeneratedType(XMLStreamReader reader, String text, String attr) throws XMLStreamException {
        int storageId = -1;
        for (Schema schema : this.tx.getSchemas().getVersions().values()) {
            ObjType objType;
            try {
                objType = this.parseGeneratedType(reader, text, attr, schema);
            }
            catch (XMLStreamException e) {
                continue;
            }
            if (storageId != -1 && storageId != objType.getStorageId()) {
                throw new XMLStreamException("invalid object type `" + attr + "' in generated object ID `" + text + "': two or more incompatible object types named `" + attr + "' exist (in different schema versions)", reader.getLocation());
            }
            storageId = objType.getStorageId();
        }
        if (storageId == -1) {
            throw new XMLStreamException("invalid object type `" + attr + "' in generated object ID `" + text + "': no such object type found in any schema version", reader.getLocation());
        }
        return storageId;
    }

    private ObjType parseGeneratedType(XMLStreamReader reader, String text, String attr, Schema schema) throws XMLStreamException {
        int storageId;
        NameIndex nameIndex = this.nameIndexMap.get(schema.getVersionNumber());
        SchemaObjectType schemaObjectType = nameIndex.getSchemaObjectType(attr);
        if (schemaObjectType != null) {
            return schema.getObjType(schemaObjectType.getStorageId());
        }
        try {
            storageId = Integer.parseInt(attr);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("invalid object type `" + attr + "' in generated object ID `" + text + "': no such object type found in schema version " + schema.getVersionNumber(), reader.getLocation());
        }
        try {
            return schema.getObjType(storageId);
        }
        catch (UnknownTypeException e) {
            throw new XMLStreamException("invalid storage ID " + storageId + " in generated object ID `" + text + "': no such object type found in schema version " + schema.getVersionNumber(), reader.getLocation());
        }
    }

    private void writeOpenTag(XMLStreamWriter writer, boolean empty, QName element, int storageId, ObjId id, int version) throws XMLStreamException {
        if (empty) {
            writer.writeEmptyElement(element.getNamespaceURI(), element.getLocalPart());
        } else {
            writer.writeStartElement(element.getNamespaceURI(), element.getLocalPart());
        }
        if (storageId != -1) {
            this.writeAttribute(writer, STORAGE_ID_ATTR, storageId);
        }
        this.writeAttribute(writer, ID_ATTR, id);
        this.writeAttribute(writer, VERSION_ATTR, version);
    }

    private void writeAttribute(XMLStreamWriter writer, QName attr, Object value) throws XMLStreamException {
        writer.writeAttribute(attr.getNamespaceURI(), attr.getLocalPart(), "" + value);
    }

    private QName next(XMLStreamReader reader) throws XMLStreamException {
        int eventType;
        do {
            if (!reader.hasNext()) {
                throw new XMLStreamException("unexpected end of input", reader.getLocation());
            }
            eventType = reader.next();
            if (eventType != 2) continue;
            return null;
        } while (eventType != 1);
        return reader.getName();
    }
}

