/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.schema;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dellroad.stuff.string.StringEncoder;
import org.jsimpledb.core.InvalidSchemaException;
import org.jsimpledb.core.type.EnumFieldType;
import org.jsimpledb.schema.SchemaFieldSwitch;
import org.jsimpledb.schema.SimpleSchemaField;
import org.jsimpledb.schema.XMLConstants;
import org.jsimpledb.util.Diffs;

public class EnumSchemaField
extends SimpleSchemaField {
    private List<String> idents = new ArrayList<String>();

    public List<String> getIdentifiers() {
        return this.idents;
    }

    @Override
    void lockDownRecurse() {
        super.lockDownRecurse();
        this.idents = Collections.unmodifiableList(this.idents);
    }

    @Override
    public <R> R visit(SchemaFieldSwitch<R> target) {
        return target.caseEnumSchemaField(this);
    }

    @Override
    void validate() {
        super.validate();
        if (this.getEncodingSignature() != 0L) {
            throw new IllegalArgumentException("invalid " + this + ": encoding signature must be zero");
        }
        try {
            EnumFieldType.validateIdentifiers(this.idents);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSchemaException("invalid " + this + ": " + e.getMessage(), e);
        }
    }

    @Override
    void validateType() {
    }

    @Override
    boolean isCompatibleType(SimpleSchemaField field) {
        EnumSchemaField that = (EnumSchemaField)field;
        return this.idents.equals(that.idents);
    }

    @Override
    void writeFieldTypeCompatibilityHashData(DataOutputStream output) throws IOException {
        output.writeInt(this.idents.size());
        for (String ident : this.idents) {
            output.writeUTF(ident);
        }
    }

    @Override
    void readSubElements(XMLStreamReader reader, int formatVersion) throws XMLStreamException {
        while (this.expect(reader, true, new QName[]{XMLConstants.IDENTIFIER_TAG})) {
            this.idents.add(reader.getElementText());
        }
    }

    @Override
    void writeXML(XMLStreamWriter writer, boolean includeName) throws XMLStreamException {
        writer.writeStartElement(XMLConstants.ENUM_FIELD_TAG.getNamespaceURI(), XMLConstants.ENUM_FIELD_TAG.getLocalPart());
        this.writeAttributes(writer, includeName);
        for (String ident : this.idents) {
            writer.writeStartElement(XMLConstants.IDENTIFIER_TAG.getNamespaceURI(), XMLConstants.IDENTIFIER_TAG.getLocalPart());
            writer.writeCharacters(StringEncoder.encode((String)ident, (boolean)false));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    void writeTypeAttribute(XMLStreamWriter writer) throws XMLStreamException {
    }

    @Override
    public Diffs differencesFrom(SimpleSchemaField other) {
        Diffs diffs = new Diffs(super.differencesFrom(other));
        if (!(other instanceof EnumSchemaField)) {
            diffs.add("change type from " + other.getClass().getSimpleName() + " to " + this.getClass().getSimpleName());
            return diffs;
        }
        EnumSchemaField that = (EnumSchemaField)other;
        if (!this.idents.equals(that.idents)) {
            int i;
            Diffs enumDiffs = new Diffs();
            TreeMap<String, Integer> thisOrdinals = new TreeMap<String, Integer>();
            TreeMap<String, Integer> thatOrdinals = new TreeMap<String, Integer>();
            for (i = 0; i < this.idents.size(); ++i) {
                thisOrdinals.put(this.idents.get(i), i);
            }
            for (i = 0; i < that.idents.size(); ++i) {
                thatOrdinals.put(that.idents.get(i), i);
            }
            PeekingIterator thisIterator = Iterators.peekingIterator(thisOrdinals.keySet().iterator());
            PeekingIterator thatIterator = Iterators.peekingIterator(thatOrdinals.keySet().iterator());
            while (thisIterator.hasNext() || thatIterator.hasNext()) {
                int diff;
                String thatName;
                String thisName = thisIterator.hasNext() ? (String)thisIterator.peek() : null;
                String string = thatName = thatIterator.hasNext() ? (String)thatIterator.peek() : null;
                assert (thisName != null || thatName != null);
                int n = thisName == null ? 1 : (diff = thatName == null ? -1 : thisName.compareTo(thatName));
                if (diff < 0) {
                    enumDiffs.add("added `" + thisName + "' (ordinal " + thisOrdinals.get(thisName) + ")");
                } else {
                    thatIterator.next();
                }
                if (diff > 0) {
                    enumDiffs.add("removed `" + thatName + "' (ordinal " + thatOrdinals.get(thatName) + ")");
                    continue;
                }
                thisIterator.next();
            }
            diffs.add("changed enum identifier list", enumDiffs);
        }
        return diffs;
    }

    @Override
    void addTypeDifference(Diffs diffs, SimpleSchemaField that) {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        EnumSchemaField that = (EnumSchemaField)obj;
        return this.idents.equals(that.idents);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.idents.hashCode();
    }

    @Override
    public EnumSchemaField clone() {
        EnumSchemaField clone = (EnumSchemaField)super.clone();
        clone.idents = new ArrayList<String>(this.idents);
        return clone;
    }
}

