/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jsimpledb.core.InvalidSchemaException;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.XMLConstants;
import org.jsimpledb.util.DiffGenerating;
import org.jsimpledb.util.Diffs;

public class SchemaCompositeIndex
extends AbstractSchemaItem
implements DiffGenerating<SchemaCompositeIndex> {
    private List<Integer> indexedFields = new ArrayList<Integer>();

    public List<Integer> getIndexedFields() {
        return this.indexedFields;
    }

    @Override
    void lockDownRecurse() {
        super.lockDownRecurse();
        this.indexedFields = Collections.unmodifiableList(this.indexedFields);
    }

    @Override
    void validate() {
        super.validate();
        if (this.indexedFields.size() < 2 || this.indexedFields.size() > 4) {
            throw new InvalidSchemaException("invalid " + this + ": between 2 and " + 4 + " fields must be specified");
        }
        HashSet<Integer> idsSeen = new HashSet<Integer>();
        for (Integer indexedField : this.indexedFields) {
            int storageId = indexedField;
            if (idsSeen.add(storageId)) continue;
            throw new InvalidSchemaException("invalid " + this + ": duplicate field in composite index: " + storageId);
        }
    }

    @Override
    void readSubElements(XMLStreamReader reader, int formatVersion) throws XMLStreamException {
        this.indexedFields.clear();
        while (this.expect(reader, true, new QName[]{XMLConstants.INDEXED_FIELD_TAG})) {
            this.indexedFields.add(this.getIntAttr(reader, XMLConstants.STORAGE_ID_ATTRIBUTE));
            this.expectClose(reader);
        }
        if (this.indexedFields instanceof ArrayList) {
            ((ArrayList)this.indexedFields).trimToSize();
        }
    }

    @Override
    void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XMLConstants.COMPOSITE_INDEX_TAG.getNamespaceURI(), XMLConstants.COMPOSITE_INDEX_TAG.getLocalPart());
        this.writeAttributes(writer, true);
        for (int storageId : this.indexedFields) {
            writer.writeEmptyElement(XMLConstants.INDEXED_FIELD_TAG.getNamespaceURI(), XMLConstants.INDEXED_FIELD_TAG.getLocalPart());
            writer.writeAttribute(XMLConstants.STORAGE_ID_ATTRIBUTE.getNamespaceURI(), XMLConstants.STORAGE_ID_ATTRIBUTE.getLocalPart(), "" + storageId);
        }
        writer.writeEndElement();
    }

    boolean isCompatibleWith(SchemaCompositeIndex that) {
        return this.indexedFields.equals(that.indexedFields);
    }

    @Override
    void writeCompatibilityHashData(DataOutputStream output) throws IOException {
        super.writeCompatibilityHashData(output);
        output.writeInt(this.indexedFields.size());
        for (Integer storageId : this.indexedFields) {
            output.writeInt(storageId);
        }
    }

    public Diffs differencesFrom(SchemaCompositeIndex that) {
        Diffs diffs = new Diffs(super.differencesFrom(that));
        if (!this.indexedFields.equals(that.indexedFields)) {
            diffs.add("changed indexed field storage IDs from " + that.indexedFields + " to " + this.indexedFields);
        }
        return diffs;
    }

    @Override
    public String toString() {
        return "composite index " + super.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SchemaCompositeIndex that = (SchemaCompositeIndex)obj;
        return this.indexedFields.equals(that.indexedFields);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.indexedFields.hashCode();
    }

    @Override
    public SchemaCompositeIndex clone() {
        SchemaCompositeIndex clone = (SchemaCompositeIndex)super.clone();
        clone.indexedFields = new ArrayList<Integer>(clone.indexedFields);
        return clone;
    }
}

