/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.NavigableSet;
import org.jsimpledb.core.ComplexField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.SimpleFieldStorageInfo;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.UnsignedIntEncoder;

abstract class ComplexSubFieldStorageInfo<T, P extends ComplexField<?>>
extends SimpleFieldStorageInfo<T> {
    final P parentRepresentative;
    private final int storageIdEncodedLength;

    ComplexSubFieldStorageInfo(SimpleField<T> field, P parent) {
        super(field);
        assert (parent != null);
        assert (parent == field.parent);
        this.parentRepresentative = parent;
        this.storageIdEncodedLength = UnsignedIntEncoder.encodeLength((int)this.storageId);
    }

    @Override
    void unreferenceAll(Transaction tx, ObjId target, NavigableSet<ObjId> referrers) {
        assert (this.fieldType instanceof ReferenceFieldType);
        ByteWriter writer = new ByteWriter(this.storageIdEncodedLength + 16);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)this.storageId);
        target.writeTo(writer);
        int mark = writer.mark();
        for (ObjId referrer : referrers) {
            writer.reset(mark);
            referrer.writeTo(writer);
            this.unreference(tx, target, referrer, writer.getBytes());
        }
    }

    abstract void unreference(Transaction var1, ObjId var2, ObjId var3, byte[] var4);

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ComplexSubFieldStorageInfo that = (ComplexSubFieldStorageInfo)obj;
        return ((ComplexField)this.parentRepresentative).storageId == ((ComplexField)that.parentRepresentative).storageId;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((ComplexField)this.parentRepresentative).storageId;
    }
}

