/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.NavigableMap;
import java.util.NavigableSet;
import org.jsimpledb.core.AbstractCoreIndex;
import org.jsimpledb.core.IndexKeyFilter;
import org.jsimpledb.core.IndexMap;
import org.jsimpledb.core.IndexSet;
import org.jsimpledb.core.IndexView;
import org.jsimpledb.core.type.Tuple2FieldType;
import org.jsimpledb.index.Index;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.tuple.Tuple2;

public class CoreIndex<V, T>
extends AbstractCoreIndex
implements Index<V, T> {
    CoreIndex(KVStore kv, IndexView<V, T> indexView) {
        super(kv, 2, indexView);
    }

    @Override
    public CoreIndex<V, T> filter(int index, KeyFilter filter) {
        return new CoreIndex<V, T>(this.kv, this.getIndexView().filter(index, filter));
    }

    IndexView<V, T> getIndexView() {
        return (IndexView)this.indexView;
    }

    public NavigableSet<Tuple2<V, T>> asSet() {
        IndexView<V, T> iv = this.getIndexView();
        Tuple2FieldType<V, T> tupleFieldType = new Tuple2FieldType<V, T>(iv.getValueType(), iv.getTargetType());
        IndexSet indexSet = new IndexSet(this.kv, tupleFieldType, iv.prefixMode, iv.prefix);
        if (iv.hasFilters()) {
            indexSet = indexSet.filterKeys(new IndexKeyFilter(this.kv, iv, 2));
        }
        return indexSet;
    }

    public NavigableMap<V, NavigableSet<T>> asMap() {
        IndexView<V, T> iv = this.getIndexView();
        IndexMap indexMap = new IndexMap.OfValues<V, T>(this.kv, iv);
        if (this.indexView.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, iv, 1));
        }
        return indexMap;
    }
}

