/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.NavigableMap;
import java.util.NavigableSet;
import org.jsimpledb.core.AbstractCoreIndex;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.Index2View;
import org.jsimpledb.core.Index3View;
import org.jsimpledb.core.IndexKeyFilter;
import org.jsimpledb.core.IndexMap;
import org.jsimpledb.core.IndexSet;
import org.jsimpledb.core.IndexView;
import org.jsimpledb.core.type.Tuple4FieldType;
import org.jsimpledb.index.Index;
import org.jsimpledb.index.Index2;
import org.jsimpledb.index.Index3;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.tuple.Tuple2;
import org.jsimpledb.tuple.Tuple3;
import org.jsimpledb.tuple.Tuple4;

public class CoreIndex3<V1, V2, V3, T>
extends AbstractCoreIndex
implements Index3<V1, V2, V3, T> {
    CoreIndex3(KVStore kv, Index3View<V1, V2, V3, T> indexView) {
        super(kv, 4, indexView);
    }

    @Override
    public CoreIndex3<V1, V2, V3, T> filter(int index, KeyFilter filter) {
        return new CoreIndex3<V1, V2, V3, T>(this.kv, this.getIndex3View().filter(index, filter));
    }

    Index3View<V1, V2, V3, T> getIndex3View() {
        return (Index3View)this.indexView;
    }

    public NavigableSet<Tuple4<V1, V2, V3, T>> asSet() {
        Index3View<V1, V2, V3, T> iv = this.getIndex3View();
        Tuple4FieldType<V1, V2, V3, T> fieldType = new Tuple4FieldType<V1, V2, V3, T>(iv.getValue1Type(), iv.getValue2Type(), iv.getValue3Type(), iv.getTargetType());
        IndexSet indexSet = new IndexSet(this.kv, fieldType, iv.prefixMode, iv.prefix);
        if (iv.hasFilters()) {
            indexSet = indexSet.filterKeys(new IndexKeyFilter(this.kv, iv, 4));
        }
        return indexSet;
    }

    public NavigableMap<Tuple3<V1, V2, V3>, NavigableSet<T>> asMap() {
        Index3View<V1, V2, V3, T> iv = this.getIndex3View();
        IndexView<Tuple3<V1, V2, V3>, T> tupleIV = iv.asTuple3IndexView();
        IndexMap indexMap = new IndexMap.OfValues<Tuple3<V1, V2, V3>, T>(this.kv, tupleIV);
        if (tupleIV.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, tupleIV, 1));
        }
        return indexMap;
    }

    public NavigableMap<Tuple2<V1, V2>, Index<V3, T>> asMapOfIndex() {
        Index3View<V1, V2, V3, T> iv = this.getIndex3View();
        Index2View<Tuple2<V1, V2>, V3, T> tupleIV = iv.asTuple2Index2View();
        IndexMap indexMap = new IndexMap.OfIndex<Tuple2<V1, V2>, V3, T>(this.kv, tupleIV);
        if (iv.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, tupleIV, 1));
        }
        return indexMap;
    }

    public NavigableMap<V1, Index2<V2, V3, T>> asMapOfIndex2() {
        Index3View<V1, V2, V3, T> iv = this.getIndex3View();
        IndexMap indexMap = new IndexMap.OfIndex2<V1, V2, V3, T>(this.kv, iv);
        if (iv.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, iv, 1));
        }
        return indexMap;
    }

    public CoreIndex2<V1, V2, V3> asIndex2() {
        return new CoreIndex2<V1, V2, V3>(this.kv, this.getIndex3View().asIndex2View());
    }

    public CoreIndex<V1, V2> asIndex() {
        return new CoreIndex<V1, V2>(this.kv, this.getIndex3View().asIndex2View().asIndexView());
    }
}

