/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import java.io.Serializable;

public class EnumValue
implements Serializable {
    private static final long serialVersionUID = 7325751293674981562L;
    private final String name;
    private final int ordinal;

    public EnumValue(String name, int ordinal) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0, (Object)"invalid negative ordinal");
        this.name = name;
        this.ordinal = ordinal;
    }

    public EnumValue(Enum<?> value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        this.name = value.name();
        this.ordinal = value.ordinal();
    }

    public String getName() {
        return this.name;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public <T extends Enum<T>> T find(Class<T> type) {
        T value;
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        try {
            value = Enum.valueOf(type, this.name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return (T)(((Enum)value).ordinal() == this.ordinal ? value : null);
    }

    public String toString() {
        return this.name + "#" + this.ordinal;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.ordinal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EnumValue that = (EnumValue)obj;
        return this.name.equals(that.name) && this.ordinal == that.ordinal;
    }
}

