/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Comparator;
import org.jsimpledb.kv.KeyRanges;

class FieldMonitor {
    public static final Comparator<FieldMonitor> SORT_BY_PATH_LENGTH = Comparator.comparingInt(m -> m.path.length);
    final int storageId;
    final int[] path;
    final KeyRanges[] filters;
    final Object listener;

    FieldMonitor(int fieldStorageId, int[] path, KeyRanges[] filters, Object listener) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"null path");
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        Preconditions.checkArgument((filters == null || filters.length == path.length + 1 ? 1 : 0) != 0, (Object)"wrong filters length");
        this.storageId = fieldStorageId;
        this.filters = filters != null ? (KeyRanges[])filters.clone() : null;
        this.path = (int[])path.clone();
        this.listener = listener;
    }

    public int getStorageId(int step) {
        return this.path[this.path.length - 1 - step];
    }

    public KeyRanges getFilter(int step) {
        return this.filters != null ? this.filters[this.path.length - step] : null;
    }

    public KeyRanges getTargetFilter() {
        return this.getFilter(0);
    }

    public int hashCode() {
        return this.storageId ^ Arrays.hashCode(this.path) ^ Arrays.hashCode(this.filters) ^ this.listener.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FieldMonitor that = (FieldMonitor)obj;
        return this.storageId == that.storageId && Arrays.equals(this.path, that.path) && Arrays.equals(this.filters, that.filters) && this.listener.equals(that.listener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[storageId=" + this.storageId + ",path=" + Ints.asList((int[])this.path) + ",filters=" + Arrays.asList(this.filters) + ",listener=" + this.listener + "]";
    }
}

