/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.util.Comparator;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.ParseContext;

public abstract class FieldType<T>
implements Comparator<T>,
Serializable {
    public static final String NAME_PATTERN = "\\p{javaJavaIdentifierStart}[-.\\p{javaJavaIdentifierPart}]*(\\[\\]){0,255}";
    public static final String REFERENCE_TYPE_NAME = "reference";
    private static final long serialVersionUID = -2295331524544358832L;
    protected final String name;
    protected final TypeToken<T> typeToken;
    protected final long signature;
    final T defaultValueObject;
    byte[] defaultValue;

    protected FieldType(String name, TypeToken<T> typeToken, long signature, T defaultValue) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        Preconditions.checkArgument((boolean)name.matches(NAME_PATTERN), (Object)("invalid type name `" + name + "'"));
        Preconditions.checkArgument((typeToken != null ? 1 : 0) != 0, (Object)"null typeToken");
        this.name = name;
        this.typeToken = typeToken;
        this.signature = signature;
        this.defaultValueObject = defaultValue;
    }

    protected FieldType(Class<T> type, long signature, T defaultValue) {
        this(type.getName(), TypeToken.of(type), signature, defaultValue);
    }

    public String getName() {
        return this.name;
    }

    public TypeToken<T> getTypeToken() {
        return this.typeToken;
    }

    public long getEncodingSignature() {
        return this.signature;
    }

    public abstract T read(ByteReader var1);

    public abstract void write(ByteWriter var1, T var2);

    public final byte[] getDefaultValue() {
        if (this.defaultValue == null) {
            ByteWriter writer = new ByteWriter();
            try {
                this.write(writer, this.defaultValueObject);
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException(this + " does not have a default value");
            }
            this.defaultValue = writer.getBytes();
        }
        return (byte[])this.defaultValue.clone();
    }

    public final T getDefaultValueObject() {
        return this.defaultValueObject;
    }

    public abstract void skip(ByteReader var1);

    public String toString(T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        return this.toParseableString(value);
    }

    public T fromString(String string) {
        ParseContext ctx = new ParseContext(string);
        T value = this.fromParseableString(ctx);
        if (!ctx.isEOF()) {
            throw new IllegalArgumentException("found trailing garbage starting with `" + ParseContext.truncate((String)ctx.getInput(), (int)20) + "'");
        }
        return value;
    }

    public abstract String toParseableString(T var1);

    public abstract T fromParseableString(ParseContext var1);

    public <S> T convert(FieldType<S> type, S value) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        try {
            return this.validate(value);
        }
        catch (IllegalArgumentException e) {
            if (value == null) {
                throw e;
            }
            return this.fromString(type.toString(value));
        }
    }

    public T validate(Object obj) {
        try {
            return this.typeToken.getRawType().cast(obj);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(this + " does not support values of type " + obj.getClass().getName());
        }
    }

    @Override
    public abstract int compare(T var1, T var2);

    public boolean hasPrefix0x00() {
        return true;
    }

    public boolean hasPrefix0xff() {
        return true;
    }

    public void validateAndWrite(ByteWriter writer, Object obj) {
        this.write(writer, this.validate(obj));
    }

    public FieldType<T> genericizeForIndex() {
        return this;
    }

    FieldTypeRegistry.Key toKey() {
        return new FieldTypeRegistry.Key(this.name, this.signature);
    }

    public String toString() {
        return "field type `" + this.name + "'";
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.typeToken.hashCode() ^ Long.hashCode(this.signature);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FieldType that = (FieldType)obj;
        return this.name.equals(that.name) && this.typeToken.equals(that.typeToken) && this.signature == that.signature;
    }
}

