/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.List;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyFilterUtil;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;

class FieldTypesFilter
implements KeyFilter {
    private static final int OK = 0;
    private static final int INVALID = 1;
    private static final int TOOSHORT = 2;
    private final byte[] prefix;
    private final FieldType<?>[] fieldTypes;
    private final KeyFilter[] filters;

    FieldTypesFilter(byte[] prefix, FieldType<?> ... fieldTypes) {
        Preconditions.checkArgument((fieldTypes != null ? 1 : 0) != 0, (Object)"null fieldTypes");
        this.prefix = prefix != null ? (byte[])prefix.clone() : ByteUtil.EMPTY;
        for (FieldType<?> fieldType : this.fieldTypes = fieldTypes) {
            Preconditions.checkArgument((fieldType != null ? 1 : 0) != 0, (Object)"null fieldType");
        }
        this.filters = new KeyFilter[this.fieldTypes.length];
    }

    FieldTypesFilter(byte[] prefix, FieldType<?>[] fieldTypes, KeyFilter[] filters, int start, int end) {
        this(prefix, Arrays.copyOfRange(fieldTypes, start, end));
        Preconditions.checkArgument((filters != null && filters.length == fieldTypes.length ? 1 : 0) != 0, (Object)"bogus filters");
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            this.filters[i] = filters[start + i];
        }
    }

    private FieldTypesFilter(FieldTypesFilter original) {
        this.prefix = original.prefix;
        this.fieldTypes = original.fieldTypes;
        this.filters = (KeyFilter[])original.filters.clone();
    }

    public List<FieldType<?>> getFieldTypes() {
        return Arrays.asList((Object[])this.fieldTypes.clone());
    }

    public KeyFilter getFilter(int index) {
        return this.filters[index];
    }

    public boolean hasFilters() {
        for (KeyFilter filter : this.filters) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }

    public FieldTypesFilter filter(int index, KeyFilter keyFilter) {
        Preconditions.checkArgument((keyFilter != null ? 1 : 0) != 0, (Object)"null keyFilter");
        if (keyFilter instanceof KeyRanges && ((KeyRanges)keyFilter).isFull()) {
            return this;
        }
        if (this.filters[index] != null) {
            keyFilter = KeyFilterUtil.intersection((KeyFilter[])new KeyFilter[]{keyFilter, this.filters[index]});
        }
        FieldTypesFilter copy = new FieldTypesFilter(this);
        copy.filters[index] = keyFilter;
        return copy;
    }

    public String toString() {
        return "FieldTypesFilter[prefix=" + ByteUtil.toString((byte[])this.prefix) + ",fieldTypes=" + Arrays.asList(this.fieldTypes) + ",filters=" + Arrays.asList(this.filters) + "]";
    }

    public boolean contains(byte[] key) {
        byte[] next = this.seekHigher(key);
        return next != null && Arrays.equals(next, key);
    }

    public byte[] seekHigher(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        if (!ByteUtil.isPrefixOf((byte[])this.prefix, (byte[])key)) {
            if (ByteUtil.compare((byte[])key, (byte[])this.prefix) > 0) {
                return null;
            }
            return this.prefix;
        }
        ByteReader reader = new ByteReader(key, this.prefix.length);
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            int fieldStart = reader.getOffset();
            switch (this.decode(this.fieldTypes[i], reader)) {
                case 1: {
                    return ByteUtil.getNextKey((byte[])reader.getBytes(0, reader.getOffset()));
                }
                case 2: {
                    return ByteUtil.getKeyAfterPrefix((byte[])reader.getBytes(0, reader.getOffset()));
                }
            }
            KeyFilter filter = this.filters[i];
            if (filter == null) continue;
            byte[] fieldValue = Arrays.copyOfRange(key, fieldStart, reader.getOffset());
            byte[] next = filter.seekHigher(fieldValue);
            if (next == null) {
                return ByteUtil.getKeyAfterPrefix((byte[])reader.getBytes(0, fieldStart));
            }
            if (Arrays.equals(next, fieldValue)) continue;
            return Bytes.concat((byte[][])new byte[][]{reader.getBytes(0, fieldStart), next});
        }
        return key;
    }

    public byte[] seekLower(byte[] key) {
        boolean fromTheTop;
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        boolean bl = fromTheTop = key.length == 0;
        if (!fromTheTop && !ByteUtil.isPrefixOf((byte[])this.prefix, (byte[])key)) {
            if (ByteUtil.compare((byte[])key, (byte[])this.prefix) < 0) {
                return null;
            }
            fromTheTop = true;
        }
        if (fromTheTop) {
            return ByteUtil.getKeyAfterPrefix((byte[])this.prefix);
        }
        ByteReader reader = new ByteReader(key, this.prefix.length);
        ByteWriter writer = new ByteWriter(key.length);
        writer.write(key, 0, this.prefix.length);
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            FieldType<?> fieldType = this.fieldTypes[i];
            KeyFilter filter = this.filters[i];
            int fieldStart = reader.getOffset();
            boolean decodeOK = this.decode(fieldType, reader) == 0;
            int fieldStop = reader.getOffset();
            byte[] fieldValue = Arrays.copyOfRange(key, fieldStart, fieldStop);
            if (filter == null || fieldValue.length == 0) {
                writer.write(fieldValue);
                if (!decodeOK) break;
                assert (fieldValue.length > 0);
                continue;
            }
            byte[] next = filter.seekLower(fieldValue);
            if (next == null) break;
            if (!Arrays.equals(next, fieldValue) || !decodeOK) {
                writer.write(next);
                break;
            }
            writer.write(fieldValue);
        }
        return writer.getBytes();
    }

    private int decode(FieldType<?> fieldType, ByteReader reader) {
        try {
            fieldType.skip(reader);
        }
        catch (IllegalArgumentException e) {
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            return 2;
        }
        return 0;
    }
}

