/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import org.jsimpledb.core.AbstractIndexView;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypesFilter;
import org.jsimpledb.core.IndexView;
import org.jsimpledb.core.type.Tuple2FieldType;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.tuple.Tuple2;
import org.jsimpledb.util.UnsignedIntEncoder;

class Index2View<V1, V2, T>
extends AbstractIndexView {
    Index2View(int storageId, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<T> targetType) {
        this(UnsignedIntEncoder.encode((int)storageId), false, value1Type, value2Type, targetType);
    }

    Index2View(byte[] prefix, boolean prefixMode, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<T> targetType) {
        super(prefix, prefixMode, value1Type, value2Type, targetType);
    }

    private Index2View(Index2View<V1, V2, T> original) {
        super(original);
    }

    public FieldType<V1> getValue1Type() {
        return this.fieldTypes[0];
    }

    public FieldType<V2> getValue2Type() {
        return this.fieldTypes[1];
    }

    public FieldType<T> getTargetType() {
        return this.fieldTypes[2];
    }

    @Override
    public Index2View<V1, V2, T> filter(int index, KeyFilter keyFilter) {
        return (Index2View)super.filter(index, keyFilter);
    }

    @Override
    protected Index2View<V1, V2, T> copy() {
        return new Index2View<V1, V2, T>(this);
    }

    public IndexView<Tuple2<V1, V2>, T> asTuple2IndexView() {
        AbstractIndexView indexView = new IndexView(this.prefix, this.prefixMode, new Tuple2FieldType<V1, V2>(this.getValue1Type(), this.getValue2Type()), this.getTargetType());
        KeyFilter value1Filter = this.getFilter(0);
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter targetFilter = this.getFilter(2);
        if (value1Filter != null || value2Filter != null) {
            FieldTypesFilter tupleFilter = new FieldTypesFilter(null, this.getValue1Type(), this.getValue2Type());
            if (value1Filter != null) {
                tupleFilter = tupleFilter.filter(0, value1Filter);
            }
            if (value2Filter != null) {
                tupleFilter = tupleFilter.filter(1, value2Filter);
            }
            indexView = ((IndexView)indexView).filter(0, tupleFilter);
        }
        if (targetFilter != null) {
            indexView = ((IndexView)indexView).filter(1, targetFilter);
        }
        return indexView;
    }

    public IndexView<V1, V2> asIndexView() {
        KeyFilter value2Filter;
        AbstractIndexView indexView = new IndexView<V1, V2>(this.prefix, true, this.getValue1Type(), this.getValue2Type());
        KeyFilter value1Filter = this.getFilter(0);
        if (value1Filter != null) {
            indexView = ((IndexView)indexView).filter(0, value1Filter);
        }
        if ((value2Filter = this.getFilter(1)) != null) {
            indexView = ((IndexView)indexView).filter(1, value2Filter);
        }
        return indexView;
    }

    public IndexView<V2, T> asIndexView(byte[] keyPrefix) {
        KeyFilter targetFilter;
        AbstractIndexView indexView = new IndexView<V2, T>(keyPrefix, this.prefixMode, this.getValue2Type(), this.getTargetType());
        KeyFilter value2Filter = this.getFilter(1);
        if (value2Filter != null) {
            indexView = ((IndexView)indexView).filter(0, value2Filter);
        }
        if ((targetFilter = this.getFilter(2)) != null) {
            indexView = ((IndexView)indexView).filter(1, targetFilter);
        }
        return indexView;
    }
}

