/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.jsimpledb.core.AbstractIndexView;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypesFilter;
import org.jsimpledb.kv.KVPairIterator;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;

class IndexKeyFilter
implements KeyFilter {
    private final KVStore kv;
    private final byte[] prefix;
    private final FieldType<?>[] fieldTypes;
    private final KeyFilter[] filters;
    private final int prefixLen;
    private final FieldTypesFilter prefixFilter;

    IndexKeyFilter(KVStore kv, AbstractIndexView indexView, int prefixLen) {
        this(kv, indexView.prefix, indexView.fieldTypes, indexView.filters, prefixLen);
    }

    IndexKeyFilter(KVStore kv, byte[] prefix, FieldType<?>[] fieldTypes, KeyFilter[] filters, int prefixLen) {
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        Preconditions.checkArgument((prefix != null && prefix.length > 0 ? 1 : 0) != 0, (Object)"null/empty prefix");
        Preconditions.checkArgument((fieldTypes != null && fieldTypes.length > 0 ? 1 : 0) != 0, (Object)"null/empty fieldTypes");
        Preconditions.checkArgument((filters != null && filters.length == fieldTypes.length ? 1 : 0) != 0, (Object)"bogus filters");
        Preconditions.checkArgument((prefixLen >= 0 && prefixLen <= fieldTypes.length ? 1 : 0) != 0, (Object)"invalid prefixLen");
        this.kv = kv;
        this.prefix = prefix;
        this.fieldTypes = fieldTypes;
        this.filters = (KeyFilter[])filters.clone();
        this.prefixLen = prefixLen;
        this.prefixFilter = new FieldTypesFilter(this.prefix, this.fieldTypes, this.filters, 0, this.prefixLen);
    }

    public String toString() {
        return "IndexKeyFilter[prefix=" + ByteUtil.toString((byte[])this.prefix) + ",fieldTypes=" + Arrays.asList(this.fieldTypes) + ",filters=" + Arrays.asList(this.filters) + ",prefixLen=" + this.prefixLen + "]";
    }

    public boolean contains(byte[] key) {
        byte[] next = this.prefixFilter.seekHigher(key);
        if (next == null || !Arrays.equals(next, key)) {
            return false;
        }
        if (this.prefixLen == this.fieldTypes.length) {
            return true;
        }
        ByteReader reader = new ByteReader(key, this.prefix.length);
        for (FieldType<?> fieldType : this.prefixFilter.getFieldTypes()) {
            fieldType.skip(reader);
        }
        byte[] suffixPrefix = reader.getBytes(0, reader.getOffset());
        FieldTypesFilter suffixFilter = this.buildSuffixFilter(suffixPrefix);
        KVPairIterator i = new KVPairIterator(this.kv, KeyRange.forPrefix((byte[])suffixPrefix), (KeyFilter)suffixFilter, false);
        return i.hasNext();
    }

    public byte[] seekHigher(byte[] key) {
        byte[] next = this.prefixFilter.seekHigher(key);
        if (next == null || !Arrays.equals(next, key)) {
            return next;
        }
        if (this.prefixLen == this.fieldTypes.length) {
            return next;
        }
        ByteReader reader = new ByteReader(key, this.prefix.length);
        for (FieldType<?> fieldType : this.prefixFilter.getFieldTypes()) {
            fieldType.skip(reader);
        }
        byte[] suffixPrefix = reader.getBytes(0, reader.getOffset());
        FieldTypesFilter suffixFilter = this.buildSuffixFilter(suffixPrefix);
        KVPairIterator i = new KVPairIterator(this.kv, KeyRange.forPrefix((byte[])suffixPrefix), (KeyFilter)suffixFilter, false);
        i.setNextTarget(key);
        if (!i.hasNext()) {
            return ByteUtil.getKeyAfterPrefix((byte[])suffixPrefix);
        }
        return i.next().getKey();
    }

    public byte[] seekLower(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        byte[] next = this.prefixFilter.seekLower(key);
        if (next == null) {
            return null;
        }
        if (this.prefixLen == this.fieldTypes.length) {
            return next;
        }
        ByteReader reader = new ByteReader(key, this.prefix.length);
        try {
            for (FieldType<?> fieldType : this.prefixFilter.getFieldTypes()) {
                fieldType.skip(reader);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            return next;
        }
        byte[] suffixPrefix = reader.getBytes(0, reader.getOffset());
        FieldTypesFilter suffixFilter = this.buildSuffixFilter(suffixPrefix);
        KVPairIterator i = new KVPairIterator(this.kv, KeyRange.forPrefix((byte[])suffixPrefix), (KeyFilter)suffixFilter, true);
        i.setNextTarget(next);
        if (i.hasNext()) {
            return ByteUtil.getNextKey((byte[])i.next().getKey());
        }
        return suffixPrefix;
    }

    private FieldTypesFilter buildSuffixFilter(byte[] suffixPrefix) {
        return new FieldTypesFilter(suffixPrefix, this.fieldTypes, this.filters, this.prefixLen, this.fieldTypes.length);
    }
}

