/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.List;
import org.jsimpledb.core.CollectionElementStorageInfo;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.Index2View;
import org.jsimpledb.core.ListField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.KVPairIterator;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.UnsignedIntEncoder;

class ListElementStorageInfo<E>
extends CollectionElementStorageInfo<List<E>, E, ListField<E>> {
    ListElementStorageInfo(ListField<E> field) {
        super(field);
    }

    CoreIndex2<E, ObjId, Integer> getElementIndex(Transaction tx) {
        return new CoreIndex2((KVStore)tx.kvt, new Index2View(this.storageId, this.fieldType, FieldTypeRegistry.OBJ_ID, FieldTypeRegistry.UNSIGNED_INT));
    }

    @Override
    CoreIndex<E, ObjId> getIndex(Transaction tx) {
        return this.getElementIndex(tx).asIndex();
    }

    @Override
    void unreference(Transaction tx, ObjId target, ObjId referrer, byte[] prefix) {
        List<?> list = tx.readListField(referrer, ((ListField)this.parentRepresentative).storageId, false);
        KVPairIterator i = new KVPairIterator((KVStore)tx.kvt, prefix);
        while (i.hasNext()) {
            ByteReader reader = new ByteReader(i.next().getKey());
            reader.skip(prefix.length);
            list.remove(UnsignedIntEncoder.read((ByteReader)reader));
        }
    }

    @Override
    public String toString() {
        return "list element with " + this.fieldType;
    }
}

