/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import java.util.Set;
import java.util.function.Predicate;
import org.jsimpledb.core.ComplexSubFieldStorageInfo;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;

class MapKeyStorageInfo<K>
extends ComplexSubFieldStorageInfo<K, MapField<K, ?>> {
    MapKeyStorageInfo(MapField<K, ?> field) {
        super(field.keyField, field);
    }

    @Override
    void unreference(Transaction tx, ObjId target, ObjId referrer, byte[] prefix) {
        tx.readMapField(referrer, ((MapField)this.parentRepresentative).storageId, false).remove(target);
    }

    @Override
    void readAllNonNull(Transaction tx, ObjId target, Set<K> values, Predicate<? super K> filter) {
        for (Object key : ((MapField)this.parentRepresentative).getValueInternal(tx, target).keySet()) {
            if (key == null || filter != null && !filter.test(key)) continue;
            values.add(key);
        }
    }

    @Override
    public String toString() {
        return "map key field with " + this.fieldType;
    }
}

