/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.SortedSet;
import org.jsimpledb.core.DeleteAction;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldSwitch;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.core.util.ObjIdMap;
import org.jsimpledb.util.ByteReader;

public class ReferenceField
extends SimpleField<ObjId> {
    final DeleteAction onDelete;
    final boolean cascadeDelete;
    final boolean allowDeleted;
    final boolean allowDeletedSnapshot;

    ReferenceField(String name, int storageId, Schema schema, DeleteAction onDelete, boolean cascadeDelete, boolean allowDeleted, boolean allowDeletedSnapshot, Set<Integer> objectTypes) {
        super(name, storageId, schema, new ReferenceFieldType(objectTypes), true);
        Preconditions.checkArgument((onDelete != null ? 1 : 0) != 0, (Object)"null onDelete");
        this.onDelete = onDelete;
        this.cascadeDelete = cascadeDelete;
        this.allowDeleted = allowDeleted;
        this.allowDeletedSnapshot = allowDeletedSnapshot;
    }

    public DeleteAction getOnDelete() {
        return this.onDelete;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public boolean isAllowDeleted() {
        return this.allowDeleted;
    }

    public boolean isAllowDeletedSnapshot() {
        return this.allowDeletedSnapshot;
    }

    public SortedSet<Integer> getObjectTypes() {
        return ((ReferenceFieldType)this.fieldType).getObjectTypes();
    }

    @Override
    public <R> R visit(FieldSwitch<R> target) {
        return target.caseReferenceField(this);
    }

    @Override
    public String toString() {
        return "reference field `" + this.name + "'";
    }

    @Override
    protected boolean remapsObjectId() {
        return true;
    }

    @Override
    protected ObjId remapObjectId(ObjIdMap<ObjId> objectIdMap, ObjId srcId) {
        if (srcId == null || objectIdMap == null || !objectIdMap.containsKey(srcId)) {
            return srcId;
        }
        ObjId dstId = objectIdMap.get(srcId);
        Preconditions.checkArgument((dstId != null ? 1 : 0) != 0, (Object)("can't copy " + srcId + " because " + srcId + " is remapped to null"));
        return dstId;
    }

    void findAnyDeletedAssignments(Transaction srcTx, Transaction dstTx, ObjId id) {
        if (this.parent != null) {
            for (ObjId targetId : this.parent.iterateSubField(srcTx, id, this)) {
                dstTx.checkDeletedAssignment(id, this, targetId);
            }
            return;
        }
        byte[] value = srcTx.kvt.get(this.buildKey(id));
        if (value == null) {
            return;
        }
        dstTx.checkDeletedAssignment(id, this, (ObjId)this.fieldType.read(new ByteReader(value)));
    }

    @Override
    boolean isUpgradeCompatible(Field<?> field) {
        return field.getClass() == this.getClass();
    }
}

