/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jsimpledb.core.ComplexField;
import org.jsimpledb.core.CompositeIndex;
import org.jsimpledb.core.DeleteAction;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.ReferenceField;
import org.jsimpledb.core.SchemaItem;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.StorageInfo;
import org.jsimpledb.core.UnknownTypeException;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.schema.SchemaObjectType;

public class Schema {
    final int versionNumber;
    final byte[] encodedXML;
    final SchemaModel schemaModel;
    final TreeMap<Integer, ObjType> objTypeMap = new TreeMap();
    final TreeMap<Integer, StorageInfo> storageInfoMap = new TreeMap();
    final ArrayList<HashMap<ReferenceField, KeyRanges>> deleteActionKeyRanges = new ArrayList(DeleteAction.values().length);

    Schema(int versionNumber, byte[] encodedXML, SchemaModel schemaModel, FieldTypeRegistry fieldTypeRegistry) {
        SchemaModel lockedDownSchemaModel;
        Preconditions.checkArgument((versionNumber > 0 ? 1 : 0) != 0, (Object)"non-positive versionNumber");
        Preconditions.checkArgument((schemaModel != null ? 1 : 0) != 0, (Object)"null schemaModel");
        this.versionNumber = versionNumber;
        this.encodedXML = encodedXML;
        if (schemaModel.isLockedDown()) {
            lockedDownSchemaModel = schemaModel;
        } else {
            lockedDownSchemaModel = schemaModel.clone();
            lockedDownSchemaModel.lockDown();
        }
        this.schemaModel = lockedDownSchemaModel;
        for (Object schemaObjectType : this.schemaModel.getSchemaObjectTypes().values()) {
            ObjType objType = new ObjType((SchemaObjectType)schemaObjectType, this, fieldTypeRegistry);
            int storageId = objType.getStorageId();
            ObjType otherObjType = this.objTypeMap.put(storageId, objType);
            if (otherObjType == null) continue;
            throw new IllegalArgumentException("incompatible use of storage ID " + storageId + " by both " + otherObjType + " and " + objType + " in " + this);
        }
        HashMap<Integer, String> descriptionMap = new HashMap<Integer, String>();
        for (ObjType objType : this.objTypeMap.values()) {
            this.addStorageInfo(objType, descriptionMap);
            for (Field<?> field : objType.fields.values()) {
                this.addStorageInfo(field, descriptionMap);
                if (!(field instanceof ComplexField)) continue;
                ComplexField complexField = (ComplexField)field;
                for (SimpleField<?> subField : complexField.getSubFields()) {
                    this.addStorageInfo(subField, descriptionMap);
                }
            }
            for (CompositeIndex index : objType.compositeIndexes.values()) {
                this.addStorageInfo(index, descriptionMap);
            }
        }
        HashMap<ReferenceField, KeyRanges> allObjTypesKeyRangesMap = new HashMap<ReferenceField, KeyRanges>();
        for (ObjType objType : this.objTypeMap.values()) {
            KeyRange objTypeKeyRange = ObjId.getKeyRange(objType.storageId);
            for (ReferenceField field : objType.referenceFieldsAndSubFields.values()) {
                allObjTypesKeyRangesMap.computeIfAbsent(field, f -> KeyRanges.empty()).add(objTypeKeyRange);
            }
        }
        for (DeleteAction deleteAction : DeleteAction.values()) {
            HashMap<ReferenceField, KeyRanges> fieldKeyRanges = new HashMap<ReferenceField, KeyRanges>();
            for (ObjType objType : this.objTypeMap.values()) {
                KeyRange objTypeKeyRange = ObjId.getKeyRange(objType.storageId);
                for (ReferenceField field : objType.referenceFieldsAndSubFields.values()) {
                    if (!field.onDelete.equals((Object)deleteAction)) continue;
                    fieldKeyRanges.computeIfAbsent(field, i -> KeyRanges.empty()).add(objTypeKeyRange);
                }
            }
            for (Map.Entry entry : fieldKeyRanges.entrySet()) {
                ReferenceField field = (ReferenceField)entry.getKey();
                KeyRanges keyRanges = (KeyRanges)entry.getValue();
                if (!keyRanges.equals(allObjTypesKeyRangesMap.get(field))) continue;
                entry.setValue(null);
            }
            this.deleteActionKeyRanges.add(fieldKeyRanges);
        }
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    public SortedMap<Integer, ObjType> getObjTypes() {
        return Collections.unmodifiableSortedMap(this.objTypeMap);
    }

    public ObjType getObjType(int storageId) {
        ObjType objType = this.objTypeMap.get(storageId);
        if (objType == null) {
            throw new UnknownTypeException(storageId, this.versionNumber);
        }
        return objType;
    }

    public String toString() {
        return "schema version " + this.versionNumber;
    }

    private void addStorageInfo(SchemaItem schemaItem, Map<Integer, String> descriptionMap) {
        StorageInfo storageInfo = schemaItem.toStorageInfo();
        if (storageInfo == null) {
            return;
        }
        StorageInfo previous = this.storageInfoMap.put(storageInfo.storageId, storageInfo);
        if (previous != null && !previous.equals(storageInfo)) {
            throw new IllegalArgumentException("incompatible use of storage ID " + storageInfo.storageId + " for both " + descriptionMap.get(storageInfo.storageId) + " and " + schemaItem);
        }
        descriptionMap.put(storageInfo.storageId, "" + schemaItem);
    }
}

