/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.StorageInfo;

public abstract class SchemaItem {
    public static final String NAME_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    final String name;
    final int storageId;
    final Schema schema;

    SchemaItem(String name, int storageId, Schema schema) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        Preconditions.checkArgument((boolean)name.matches(NAME_PATTERN), (Object)("invalid name `" + name + "'"));
        Preconditions.checkArgument((storageId > 0 ? 1 : 0) != 0, (Object)"invalid non-positive storageId");
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"null schema");
        this.name = name;
        this.storageId = storageId;
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public Schema getSchema() {
        return this.schema;
    }

    abstract StorageInfo toStorageInfo();

    public abstract String toString();
}

