/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.jsimpledb.core.CollectionField;
import org.jsimpledb.core.FieldSwitch;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.JSSet;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SetElementStorageInfo;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.util.ObjIdMap;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.CloseableIterator;

public class SetField<E>
extends CollectionField<NavigableSet<E>, E> {
    SetField(String name, int storageId, Schema schema, SimpleField<E> elementField) {
        super(name, storageId, schema, new TypeToken<NavigableSet<E>>(){}.where(new TypeParameter<E>(){}, elementField.typeToken.wrap()), elementField);
    }

    @Override
    public NavigableSet<E> getValue(Transaction tx, ObjId id) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        return tx.readSetField(id, this.storageId, false);
    }

    @Override
    public <R> R visit(FieldSwitch<R> target) {
        return target.caseSetField(this);
    }

    @Override
    public String toString() {
        return "set field `" + this.name + "' containing " + this.elementField;
    }

    @Override
    NavigableSet<E> getValueInternal(Transaction tx, ObjId id) {
        return new JSSet(tx, this, id);
    }

    @Override
    NavigableSet<E> getValueReadOnlyCopy(Transaction tx, ObjId id) {
        return Sets.unmodifiableNavigableSet(new TreeSet(this.getValueInternal(tx, id)));
    }

    SetElementStorageInfo<E> toStorageInfo(SimpleField<?> subField) {
        assert (subField == this.elementField);
        return new SetElementStorageInfo(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void copy(ObjId srcId, ObjId dstId, Transaction srcTx, Transaction dstTx, ObjIdMap<ObjId> objectIdMap) {
        Object d;
        Object s;
        CloseableIterator di;
        CloseableIterator si;
        Collection dst;
        Collection src;
        FieldType<Object> fieldType;
        block59: {
            fieldType = this.elementField.fieldType;
            src = this.getValue(srcTx, srcId);
            dst = this.getValue(dstTx, dstId);
            si = CloseableIterator.wrap(src.iterator());
            Throwable throwable = null;
            try {
                di = CloseableIterator.wrap(dst.iterator());
                Throwable throwable2 = null;
                try {
                    if (!si.hasNext()) {
                        dst.clear();
                        return;
                    }
                    if (objectIdMap == null || objectIdMap.isEmpty() || !this.elementField.remapsObjectId()) {
                        if (!di.hasNext()) {
                            dst.addAll(src);
                            return;
                        }
                        s = si.next();
                        d = di.next();
                        break block59;
                    }
                    dst.clear();
                    while (si.hasNext()) {
                        dst.add(this.elementField.remapObjectId(objectIdMap, si.next()));
                    }
                    return;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (di != null) {
                        if (throwable2 != null) {
                            try {
                                di.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            di.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (si != null) {
                    if (throwable != null) {
                        try {
                            si.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        si.close();
                    }
                }
            }
        }
        while (true) {
            int diff = fieldType.compare(s, d);
            boolean sadvance = true;
            boolean dadvance = true;
            if (diff < 0) {
                dst.add(s);
                dadvance = false;
            } else if (diff > 0) {
                di.remove();
                sadvance = false;
            }
            if (sadvance) {
                if (!si.hasNext()) {
                    dst.tailSet(s, false).clear();
                    return;
                }
                s = si.next();
            }
            if (!dadvance) continue;
            if (!di.hasNext()) {
                dst.addAll(src.tailSet(s, true));
                return;
            }
            d = di.next();
        }
    }

    @Override
    void buildIndexEntry(ObjId id, SimpleField<?> subField, ByteReader reader, byte[] value, ByteWriter writer) {
        assert (subField == this.elementField);
        writer.write(reader);
        id.writeTo(writer);
    }
}

