/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import java.util.BitSet;
import org.jsimpledb.core.type.NonNullFieldType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.ParseContext;
import org.jsimpledb.util.UnsignedIntEncoder;

public class BitSetType
extends NonNullFieldType<BitSet> {
    private static final long serialVersionUID = -1133774834687234873L;

    public BitSetType() {
        super(BitSet.class, 0L);
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }

    @Override
    public BitSet read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return BitSet.valueOf(this.reverse(reader.readBytes(UnsignedIntEncoder.read((ByteReader)reader))));
    }

    @Override
    public void write(ByteWriter writer, BitSet bitSet) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        Preconditions.checkArgument((bitSet != null ? 1 : 0) != 0);
        byte[] bytes = bitSet.toByteArray();
        UnsignedIntEncoder.write((ByteWriter)writer, (int)bytes.length);
        writer.write(this.reverse(bytes));
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(UnsignedIntEncoder.read((ByteReader)reader));
    }

    @Override
    public String toString(BitSet bitSet) {
        Preconditions.checkArgument((bitSet != null ? 1 : 0) != 0);
        return "[" + ByteUtil.toString((byte[])this.reverse(bitSet.toByteArray())) + "]";
    }

    @Override
    public BitSet fromString(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        int length = string.length();
        Preconditions.checkArgument((length > 0 && string.charAt(0) == '[' && string.charAt(length - 1) == ']' ? 1 : 0) != 0, (Object)("invalid BitSet string `" + string + "'"));
        return BitSet.valueOf(this.reverse(ByteUtil.parse((String)string.substring(1, length - 1))));
    }

    @Override
    public String toParseableString(BitSet bitSet) {
        return this.toString(bitSet);
    }

    @Override
    public BitSet fromParseableString(ParseContext ctx) {
        Preconditions.checkArgument((ctx != null ? 1 : 0) != 0);
        return this.fromString(ctx.matchPrefix("\\[\\p{XDigit}*\\]").group());
    }

    @Override
    public int compare(BitSet bitSet1, BitSet bitSet2) {
        int diff = Integer.compare(bitSet1.length(), bitSet2.length());
        if (diff != 0) {
            return diff;
        }
        byte[] bytes1 = bitSet1.toByteArray();
        byte[] bytes2 = bitSet2.toByteArray();
        assert (bytes1.length == bytes2.length);
        int i = bytes1.length;
        while (--i >= 0) {
            int v1 = bytes1[i] & 0xFF;
            int v2 = bytes2[i] & 0xFF;
            if (v1 < v2) {
                return -1;
            }
            if (v1 <= v2) continue;
            return 1;
        }
        return 0;
    }

    private byte[] reverse(byte[] bytes) {
        int inc = 0;
        int dec = bytes.length - 1;
        while (inc < dec) {
            byte lo = bytes[inc];
            byte hi = bytes[dec];
            bytes[inc++] = hi;
            bytes[dec--] = lo;
        }
        return bytes;
    }
}

