/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import org.dellroad.stuff.java.Primitive;
import org.jsimpledb.core.type.PrimitiveType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;

public class BooleanType
extends PrimitiveType<Boolean> {
    private static final long serialVersionUID = 5941222137600409101L;
    private static final byte FALSE_VALUE = 0;
    private static final byte TRUE_VALUE = 1;

    public BooleanType() {
        super(Primitive.BOOLEAN);
    }

    @Override
    public Boolean read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        int value = reader.readByte();
        switch (value) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new IllegalArgumentException(String.format("invalid encoded boolean value 0x%02x", value));
    }

    @Override
    public void write(ByteWriter writer, Boolean value) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        writer.writeByte(value != false ? 1 : 0);
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        this.read(reader);
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }

    @Override
    protected Boolean convertNumber(Number value) {
        return value.doubleValue() != 0.0;
    }
}

