/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.core.type;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dellroad.stuff.java.EnumUtil;
import org.jsimpledb.core.EnumValue;
import org.jsimpledb.core.type.EnumType;
import org.jsimpledb.core.type.NullSafeType;

public class EnumFieldType
extends NullSafeType<EnumValue> {
    public static final String IDENT_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final long serialVersionUID = -968533056184967301L;

    public <T extends Enum<T>> EnumFieldType(Class<T> enumType) {
        this(EnumFieldType.getIdentifiers(enumType));
    }

    public EnumFieldType(List<String> idents) {
        super(new EnumType(idents));
    }

    public List<String> getIdentifiers() {
        return ((EnumType)this.inner).getIdentifiers();
    }

    public static Map<String, EnumValue> validateIdentifiers(List<String> idents) {
        Preconditions.checkArgument((idents != null ? 1 : 0) != 0, (Object)"null idents");
        LinkedHashMap<String, EnumValue> identifierMap = new LinkedHashMap<String, EnumValue>(idents.size());
        for (String ident : idents) {
            int index = identifierMap.size();
            Preconditions.checkArgument((ident != null ? 1 : 0) != 0, (Object)("invalid null enum identifier at index " + index));
            Preconditions.checkArgument((!ident.equals("null") && ident.matches(IDENT_PATTERN) ? 1 : 0) != 0, (Object)("invalid enum identifier `" + ident + "' at index " + index));
            EnumValue otherValue = identifierMap.put(ident, new EnumValue(ident, index));
            if (otherValue == null) continue;
            throw new IllegalArgumentException("invalid duplicate enum identifier `" + ident + "' at indexes " + otherValue.getOrdinal() + " and " + index);
        }
        return identifierMap;
    }

    private static <T extends Enum<T>> List<String> getIdentifiers(Class<T> enumType) {
        return EnumUtil.getValues(enumType).stream().map(Enum::name).collect(Collectors.toList());
    }
}

